using System;
using System.Collections;
using System.Collections.Generic;
#if HAVE_GNOME_KEYRING
using Gnome.Keyring;
#endif

namespace bareFTP.Preferences
{
	
	
	public class PwdBackend
	{
		
		const string RootPath = "bareftp";
		
		public PwdBackend()
		{
			
		}
		
		public string GetPwd(int keyid)
		{
#if HAVE_GNOME_KEYRING
			if(!Ring.Available)
				throw new Exception("Gnome Keyring not available");
			
			if(keyid > -1)
			{
				try
				{
					ItemData item = Ring.GetItemInfo(Ring.GetDefaultKeyring(), keyid);
					//if(item.Attributes["obj"] == "bareftp")
						return item.Secret;
				}
				catch (KeyringException e) {
					return string.Empty;
				}
			}
			return string.Empty;
			/*
			string _protocol = "ftp";
			if(protocol == 3)
				_protocol = "sftp";
			
			Hashtable hash = new Hashtable();
			hash["user"] = user;
			hash["server"] = host;
			hash["protocol"] = _protocol;
			hash["obj"] = "bareftp";
			if(!string.IsNullOrEmpty(port))
				hash["port"] = Convert.ToInt32(port);
			
			try {
				ItemData[] datatbl = Ring.Find(ItemType.NetworkPassword, hash);
				if(datatbl != null && datatbl.Length > 0)
				{
					foreach(ItemData d in datatbl)
					{
						if(d.ItemID == keyid)
							return d.Secret;
					}
					return datatbl[0].Secret;
				}
				else
					return string.Empty;
			} catch (KeyringException e) {
				return null;
			}
			*/
#else
			return string.Empty;
#endif

			
		}
		
		public int SetPwd(string user, string host, int protocol, string port, string passwd, bool isnew)
		{
#if HAVE_GNOME_KEYRING
			
			if (!Ring.Available) {
				throw new Exception("Gnome Keyring not available");
			}
			
			string _protocol = "ftp";
			if(protocol == 3)
				_protocol = "sftp";
			
			Hashtable hash = new Hashtable();
			hash["user"] = user;
			hash["server"] = host;
			hash["protocol"] = _protocol;
			hash["obj"] = "bareftp";
			if(!string.IsNullOrEmpty(port))
				hash["port"] = Convert.ToInt32(port);
			
			
			int keyid = -1;
			
			try {
				keyid = Ring.CreateItem(Ring.GetDefaultKeyring(), ItemType.NetworkPassword, 
				                "bareftp:" + user + "@" + host, hash, passwd, isnew);
			} catch (KeyringException e) {
				return -1;
			}

			return keyid;
#else
			return -1;
#endif
		}
		
		public bool HasGnomeKeyring
		{
			get
			{ 
#if HAVE_GNOME_KEYRING
				
				try { return Ring.Available; }
				catch { return false; }
#else
				return false;
#endif
			}
		}
		
		public void CleanUpItems()
		{
#if HAVE_GNOME_KEYRING
			if(!Ring.Available)
				throw new Exception("Gnome Keyring not available");
			
			Hashtable hash = new Hashtable();
			hash["obj"] = "bareftp";
			
			try {
				ItemData[] datatbl = Ring.Find(ItemType.NetworkPassword, hash);
				if(datatbl != null && datatbl.Length > 0)
				{
					foreach(ItemData d in datatbl)
					{
						Ring.DeleteItem(Ring.GetDefaultKeyring(), d.ItemID);
					}
					
				}
				
			} catch (KeyringException e) {
				
			}
#endif
		}
		
		public bool DeletePassword(int keyid)
		{
#if HAVE_GNOME_KEYRING
			if(!Ring.Available)
				throw new Exception("Gnome Keyring not available");
			
			try {
				ItemData data = Ring.GetItemInfo(Ring.GetDefaultKeyring(), keyid);
				if(data != null)
				{
					
					if(data.ItemID == keyid)
					{
						Ring.DeleteItem(Ring.GetDefaultKeyring(), data.ItemID);
						return true;
					}
				}
				
			} catch (KeyringException e) {
				return false;
			}
#endif
			return false;
		}

		
	}
}
