#!/bin/bash
# -*- shell-script -*-

test_preserve_set_opts()
{
    set -u
    old_opts=$-
    # If running make distcheck we can't use top_builddir
    # because some files aren't there but are in the install
    # directory. 
    if [[ -f $top_builddir/dbg-opts.sh ]] ; then
	libdir=${top_builddir}
    else
	libdir=${prefix}/share/bashdb
    fi
    if [[ -f $libdir/dbg-opts.sh ]] ; then
	# Name we refer to ourselves by
	typeset _Dbg_debugger_name='bashdb'
	# The release name we are configured to run under.
	typeset _Dbg_release='4.2-0.6'
	. ${top_builddir}/bashdb-trace -L $libdir
	assertEquals $old_opts $-
    else
	echo 'Skipping test - building outside of source complications'
    fi

    (. ${top_builddir}/bashdb-trace -L $libdir/dbg-opts.sh)
    assertEquals $? 1

}

# load shunit2
prefix=/usr/local
top_builddir=/src/external-vcs/bashdb
top_srcdir=/src/external-vcs/bashdb
. ${top_srcdir}/lib/filecache.sh
. ${top_srcdir}/lib/sig.sh
. ${top_srcdir}/lib/help.sh
. ${top_srcdir}/command/trace.sh

srcdir=.
srcdir=${srcdir}/
. ${srcdir}/shunit2

