/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef APPSETTINGS_H
#define APPSETTINGS_H

#include <qstring.h>
#include <kdialogbase.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtooltip.h>

class KIntNumInput;
class KGlobalAccel;

class Container;
class ContainerSystemTray;
class DebugWindow;
class LinkLook;
class LinkLookEditWidget;

#include "container.h"   // For AppSettings::tray call from other files (UGLLY)

/**
  *Handle all global variables (to avoid lot of extern declarations)
  *@author Sbastien Laot
  */
class AppSettings // FIXME: Distaptch new config events ?
{                 // FIXME: Rename to AppGlobal
  public: /* This class just aims to store those global variables : */
	/** Global objects */
	static DebugWindow          *debugWindow;
	static QString               appPath;       // FIXME: Do a static method
	static Container            *mainContainer;
	static ContainerSystemTray  *tray;          // To doesn't have to define ContainerSystemTray out of main.cpp
	static KGlobalAccel         *globalAccel;
  protected:
	/** App settings */                 // FIXME: Move ones of those properties in Container
	static bool m_tabsOnTop;
	static bool m_useSystray;
	static int  m_showAtStart;          // O:No ; 1:Yes ; 2:Last
	static bool m_wasShown;
	static bool m_useCleverShowHide;
	static bool m_hideOnClose;
	static bool m_hideOnMinimize;
	static bool m_hideOnEscape;
	static bool m_showSystrayToolTip;
	static int  m_lastBasket;
	static int  m_dropTimeToShow;
	static bool m_instantToolTips;
	static bool m_usePassivePopup;
	static int  m_whereToCopy;
  public:  /* And the following methods are just getter / setters */
	/** App settings GET */
	static inline bool tabsOnTop()          { return m_tabsOnTop;          }
	static inline bool useSystray()         { return m_useSystray;         }
	static inline int  showAtStart()        { return m_showAtStart;        }
	static inline bool wasShown()           { return m_wasShown;           }
	static inline bool useCleverShowHide()  { return m_useCleverShowHide;  }
	static inline bool hideOnClose()        { return m_hideOnClose;        }
	static inline bool hideOnMinimize()     { return m_hideOnMinimize;     }
	static inline bool hideOnEscape()       { return m_hideOnEscape;       }
	static inline bool showSystrayToolTip() { return m_showSystrayToolTip; }
	static inline int  lastBasket()         { return m_lastBasket;         }
	static inline int  dropTimeToShow()     { return m_dropTimeToShow;     }
	static inline bool instantToolTips()    { return m_instantToolTips;    }
	static inline bool usePassivePopup()    { return m_usePassivePopup;    }
	static inline int  whereToCopy()        { return m_whereToCopy;        }
	/** App settings SET */
	static inline void setTabsOnTop(bool tabsOnTop)    { m_tabsOnTop          = tabsOnTop;   }
	static inline void setUseSystray(bool useSystray)  { m_useSystray         = useSystray;  }
	static inline void setShowAtStart(int showAtStart) { m_showAtStart        = showAtStart; }
	static inline void setWasShown(bool wasShown)      { m_wasShown           = wasShown;    }
	static inline void setUseCleverShowHide(bool use)  { m_useCleverShowHide  = use;         }
	static inline void setHideOnClose(bool hide)       { m_hideOnClose        = hide;        }
	static inline void setHideOnMinimize(bool hide)    { m_hideOnMinimize     = hide;        }
	static inline void setHideOnEscape(bool hide)      { m_hideOnEscape       = hide;        }
	static inline void setShowSystrayToolTip(bool use) { m_showSystrayToolTip = use;
	                                                     if (AppSettings::tray)
	                                                     	AppSettings::tray->updateToolTip(); }
	static inline void setLastBasket(int lastBasket)   { m_lastBasket         = lastBasket;  }
	static inline void setDropTimeToShow(int time)     { m_dropTimeToShow     = time;        }
	static inline void setInstantToolTips(bool enable) { m_instantToolTips    = enable;
	                                                     QToolTip::setWakeUpDelay(enable?0:700); }
	                                                     // FIXME: How to get this value from user preferences ?
	static inline void setUsePassivePopup(bool enable) { m_usePassivePopup    = enable;      }
	static inline void setWhereToCopy(int where)       { m_whereToCopy        = where;       }
  public:
	/* Save and load config */
	static void loadConfig();
	static void saveConfig();
  protected:
	static void loadLinkLook(LinkLook* &look, const QString &name, LinkLook *defaultL);
	static void saveLinkLook(LinkLook *look, const QString &name);
};

/**
  *Provide a dialog for modify application settings
  *@author Sbastien Laot
  */
class AppSettingsDialog : public KDialogBase
{
  Q_OBJECT
  public:
	AppSettingsDialog(QWidget *parent = 0);
	~AppSettingsDialog();
  protected slots:
	void slotApply();
	void slotOk();
	void slotEnableSystray(bool on);
  private:
	// Main window
	QComboBox          *m_tabsOnTop;
	KIntNumInput       *m_dropTimeToShow;
	QCheckBox          *m_instantToolTips;
	QCheckBox          *m_usePassivePopup;
	// System tray
	QCheckBox          *m_useSystray;
	QWidget            *m_systray;
	QCheckBox          *m_useCleverShowHide;
	QCheckBox          *m_hideOnClose;
	QCheckBox          *m_hideOnMinimize;
	QCheckBox          *m_hideOnEscape;
	QCheckBox          *m_showSystrayToolTip;
	QComboBox          *m_showAtStart;
	// Links
	LinkLookEditWidget *m_localLC;
	LinkLookEditWidget *m_urlLC;
	LinkLookEditWidget *m_noUrlLC;
};

#endif // APPSETTINGS_H
