/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <kcolorbutton.h>
#include <kiconloader.h>
#include <qiconset.h>
#include <kicondialog.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <kpushbutton.h>
#include <qcombobox.h>
#include <kurllabel.h>
#include <kmessagebox.h>

#include "basket.h"
#include "basketproperties.h"
#include "appsettings.h"
#include "onclickaction.h"

/** BasketPropertiesWidget */

BasketPropertiesWidget::BasketPropertiesWidget(Basket *basket, QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	QHBoxLayout	*hLay;
	QLabel		*label;

	m_basket = basket;
	QVBoxLayout *vLay = new QVBoxLayout(this);

	hLay   = new QHBoxLayout(0, 0, 6);
	m_name = new QLineEdit(m_basket->name(), this);
	label  = new QLabel(m_name, i18n("&Name :"), this);
	hLay->addWidget(label);
	hLay->addWidget(m_name);
	vLay->addLayout(hLay);

	hLay   = new QHBoxLayout(0, 0, 6);
	m_icon = new KIconButton(this);
	label  = new QLabel(m_icon, i18n("&Icon :"), this);
	m_icon->setIconType (KIcon::Small, KIcon::Any);
	if ( ! basket->icon().isEmpty())
		m_icon->setIcon(basket->icon());
	QPushButton *button = new QPushButton(i18n("Non&e"), this);
	hLay->addWidget(label);
	hLay->addWidget(m_icon);
	hLay->addWidget(button);
	hLay->addStretch();
	vLay->addLayout(hLay);
	connect( button, SIGNAL(pressed()), this, SLOT(emptyIcon()) );

	hLay = new QHBoxLayout(0, 0, 6);
	m_useColor = new QCheckBox(i18n("&Background color :"), this);
	m_useColor->setChecked(basket->useColor());
	m_color = new KColorButton(basket->color(), this);
	m_color->setEnabled(m_useColor->isChecked());
	hLay->addWidget(m_useColor);
	hLay->addWidget(m_color);
	hLay->addStretch();
	vLay->addLayout(hLay);
	connect( m_useColor, SIGNAL(toggled(bool)), m_color, SLOT(setEnabled(bool)) );

	hLay = new QHBoxLayout(0, 0, 6);
	m_useAltColor = new QCheckBox(i18n("Alte&rnate background color :"), this);
	m_useAltColor->setChecked(basket->useAltColor());
	m_altColor = new KColorButton(basket->altColor(), this);
	m_altColor->setEnabled(m_useAltColor->isChecked());
	hLay->addWidget(m_useAltColor);
	hLay->addWidget(m_altColor);
	hLay->addStretch();
	vLay->addLayout(hLay);
	connect( m_useAltColor, SIGNAL(toggled(bool)), m_altColor, SLOT(setEnabled(bool)) );

	m_checkable = new QCheckBox(i18n("Show items chec&k boxes"), this);
	m_checkable->setChecked(basket->isCheckable());
	vLay->addWidget(m_checkable);

	m_showAnnotations = new QCheckBox(i18n("Show items &tooltips (annotations...)"), this);
	m_showAnnotations->setChecked(basket->isShowAnnotations());
	vLay->addWidget(m_showAnnotations);

	hLay = new QHBoxLayout(0, 0, 6);
	m_hAlign = new QComboBox(this);
	label = new QLabel(m_hAlign, i18n("Items ali&gnment :"), this);
	m_hAlign->insertItem(i18n("Left"));
	m_hAlign->insertItem(i18n("Center"));
	m_hAlign->insertItem(i18n("Right"));
	m_hAlign->setCurrentItem(basket->hAlign());
	m_vAlign = new QComboBox(this);
	m_vAlign->insertItem(i18n("Top"));
	m_vAlign->insertItem(i18n("Middle"));
	m_vAlign->insertItem(i18n("Bottom"));
	m_vAlign->setCurrentItem(basket->vAlign());
	hLay->addWidget(label);
	hLay->addWidget(m_hAlign);
	hLay->addWidget(m_vAlign);
	hLay->addStretch();
	vLay->addLayout(hLay);

	m_name->setFocus();
}

BasketPropertiesWidget::~BasketPropertiesWidget()
{
}

void BasketPropertiesWidget::saveChanges()
{
	m_basket->setName(m_name->text());
	m_basket->setIcon(m_icon->icon());
	m_basket->setColor(m_useColor->isChecked(), m_color->color(), m_useAltColor->isChecked(), m_altColor->color());
	m_basket->setShowAnnotations(m_showAnnotations->isChecked());
	m_basket->setCheckable(m_checkable->isChecked());
	m_basket->setAlign(m_hAlign->currentItem(), m_vAlign->currentItem());
}

void BasketPropertiesWidget::emptyIcon()
{
	m_icon->resetIcon();
}

/** BasketPropertiesAddItemWidget */

BasketPropertiesAddItemWidget::BasketPropertiesAddItemWidget(Basket *basket, QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	m_basket = basket;

	QHBoxLayout *hLay;
	QLabel      *label;
	QVBoxLayout *vLay = new QVBoxLayout(this);

	hLay   = new QHBoxLayout(0, 0, 6);
	m_newItemPlacement = new QComboBox(this);
	label  = new QLabel(m_newItemPlacement, i18n("Place &new items"), this);
	m_newItemPlacement->insertItem(i18n("at begin (on top)"));
	m_newItemPlacement->insertItem(i18n("at end (on bottom)"));
	m_newItemPlacement->setCurrentItem( basket->newItemPlacement() == -1 ); // 0, or 1 if == -1 (at end)
	hLay->addWidget(label);
	hLay->addWidget(m_newItemPlacement);
	hLay->addStretch();
	vLay->addLayout(hLay);

	m_allowFreeDrop = new QCheckBox(i18n("&Drop objects at cursor position"), this);
	m_allowFreeDrop->setChecked(basket->allowFreeDrop());
	vLay->addWidget(m_allowFreeDrop);

	m_pasteSelAtCursorPos = new QCheckBox(i18n("Paste &selection at cursor position"), this);
	m_pasteSelAtCursorPos->setChecked(basket->pasteSelAtCursorPos());
	vLay->addWidget(m_pasteSelAtCursorPos);

	vLay->addSpacing(20);

	hLay   = new QHBoxLayout(0, 0, 6);
	m_systrayStackFrom = new QComboBox(this);
	label  = new QLabel(m_systrayStackFrom, i18n("&When drag from system tray icon,"), this);
	m_systrayStackFrom->insertItem(i18n("- Disabled drag for this basket -"));
	m_systrayStackFrom->insertItem(i18n("drag the item that is at begin (on top)"));
	m_systrayStackFrom->insertItem(i18n("drag the item that is at end (on bottom)"));
	m_systrayStackFrom->setCurrentItem( basket->systrayStackFrom() );
	hLay->addWidget(label);
	hLay->addWidget(m_systrayStackFrom);
	hLay->addStretch();
	vLay->addLayout(hLay);

	m_stackOptions = new QWidget(this);
	hLay   = new QHBoxLayout(m_stackOptions, 0, 6);
	hLay->addSpacing(20);
	QVBoxLayout *vLay2 = new QVBoxLayout(0);
	m_deleteAfterSystrayDrag = new QCheckBox(i18n("D&elete items after drag from systray icon, even if drag was aborded"), m_stackOptions);
	label  = new QLabel(i18n("<i>With this option, you can use the system tray icon as a stack of items "
	                         "(as the drop stack of the PathFinder file manager for OS X or the KDE DragStacK program).<br>"
	                         "The last option allow you to use this basket as a real stack, since items aren't deleted automatically.</i>"), m_stackOptions);
/*	                         "Tip : Maintain Shift key during drop to delete the item from the stack (and then use it as a true stack).</i>"),*/
	m_stackOptions->setEnabled( m_systrayStackFrom->currentItem() != 0 );
	m_deleteAfterSystrayDrag->setChecked(m_basket->deleteAfterSystrayDrag());
	vLay2->addWidget(m_deleteAfterSystrayDrag);
	vLay2->addWidget(label);
	//vLay2->addStretch();
	m_stackOptions->setSizePolicy( QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Maximum, 0, 0, false) );
	hLay->addLayout(vLay2);
	vLay->addWidget(m_stackOptions);
	connect( m_systrayStackFrom, SIGNAL(activated(int)), this, SLOT(systrayStackFromChanged(int)) );
}

void BasketPropertiesAddItemWidget::systrayStackFromChanged(int)
{
	m_stackOptions->setEnabled( m_systrayStackFrom->currentItem() != 0 );
}

BasketPropertiesAddItemWidget::~BasketPropertiesAddItemWidget()
{
}

void BasketPropertiesAddItemWidget::saveChanges()
{
	m_basket->setNewItemPlacement(       m_newItemPlacement->currentItem() == 1 ? -1 : 0 );
	m_basket->setAllowFreeDrop(          m_allowFreeDrop->isChecked()                    );
	m_basket->setPasteSelAtCursorPos(    m_pasteSelAtCursorPos->isChecked()              );
	m_basket->setSystrayStackFrom(       m_systrayStackFrom->currentItem()               );
	m_basket->setDeleteAfterSystrayDrag( m_deleteAfterSystrayDrag->isChecked()           );
}

/** BasketPropertiesOnClicWidget */

BasketPropertiesOnClicWidget::BasketPropertiesOnClicWidget(Basket *basket, QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	m_basket = basket;

	QVBoxLayout *vLay = new QVBoxLayout(this, 0, 6);
	QHBoxLayout *hLay;

	m_contentOnClickAction = new OnClickActionCombo(basket->contentOnClickAction(), this);
	QLabel *lbl1 = new QLabel(m_contentOnClickAction, i18n("For con&tent based items (Text, Rich text, Image and Color) :"), this);
	hLay = new QHBoxLayout(0, 0, 6);
	hLay->addSpacing(20);
	hLay->addWidget(m_contentOnClickAction);
	hLay->addStretch();
	vLay->addWidget(lbl1);
	vLay->addLayout(hLay);

	m_fileOnClickAction = new OnClickActionCombo(basket->fileOnClickAction(), this);
	QLabel *lbl2 = new QLabel(m_fileOnClickAction, i18n("For &file based items (Links) :"), this);
	hLay = new QHBoxLayout(0, 0, 6);
	hLay->addSpacing(20);
	hLay->addWidget(m_fileOnClickAction);
	hLay->addStretch();
	vLay->addWidget(lbl2);
	vLay->addLayout(hLay);

	m_runOverrideClick = new QCheckBox(i18n("If an item has a run command, &run it with a click (and override click configuration)"), this);
	m_runOverrideClick->setChecked(basket->isRunOverrideClick());
	m_runOverrideClick->setSizePolicy( QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum, 0, 0, false) );
	vLay->addWidget(m_runOverrideClick);

	KIconLoader icol;
	QIconSet    icos;

	icos = QIconSet( icol.loadIcon( "configure", KIcon::Toolbar, KIcon::SizeSmall ) );
	KPushButton *pb = new KPushButton(icos, i18n("Configure &global on click copy"), this);
	pb->setSizePolicy( QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, false) );
	hLay = new QHBoxLayout(0, 0, 6);
	hLay->addWidget(pb);
	hLay->addStretch();
	vLay->addSpacing(20);
	vLay->addLayout(hLay);
	vLay->addSpacing(20);

	KURLLabel *help = new KURLLabel(this);
	help->setText(i18n("Show all available mouse click actions and configurations"));
	vLay->addWidget(help);

	connect( help, SIGNAL(leftClickedURL()), this, SLOT(showHelp())   );
	connect( pb,   SIGNAL(clicked()),        this, SLOT(configCopy()) );
}

BasketPropertiesOnClicWidget::~BasketPropertiesOnClicWidget()
{
}

void BasketPropertiesOnClicWidget::saveChanges()
{
	m_basket->setContentOnClickAction( m_contentOnClickAction->currentItem() );
	m_basket->setFileOnClickAction(    m_fileOnClickAction->currentItem()    );
	m_basket->setRunOverrideClick(     m_runOverrideClick->isChecked()       );
}

void BasketPropertiesOnClicWidget::showHelp()
{
	OnClickAction::showHelp(this);
}

void BasketPropertiesOnClicWidget::configCopy()
{
	OnClickActionCopyDialog *dlg = new OnClickActionCopyDialog(this);
	dlg->exec();

	delete dlg;
}

/** BasketPropertiesDialog */

BasketPropertiesDialog::BasketPropertiesDialog(Basket *basket, QWidget *parent)
 : KDialogBase(KDialogBase::Tabbed, i18n("Edit basket properties"),
               KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel, KDialogBase::Ok/*(KDialogBase::ButtonCode)0*/, parent)
{
	m_basket = basket;

	QFrame *page1 = addPage(i18n("Basket &properties"));
	QVBoxLayout *layout = new QVBoxLayout(page1);
	m_properties = new BasketPropertiesWidget(basket, page1);
	layout->addWidget(m_properties);

	QFrame *page2 = addPage(i18n("Add item polic&y"));
	layout = new QVBoxLayout(page2);
	m_addPolicy = new BasketPropertiesAddItemWidget(basket, page2);
	layout->addWidget(m_addPolicy);

	QFrame *page3 = addPage(i18n("On c&lick actions"));
	layout = new QVBoxLayout(page3);
	m_onClic = new BasketPropertiesOnClicWidget(basket, page3);
	layout->addWidget(m_onClic);
}

BasketPropertiesDialog::~BasketPropertiesDialog()
{
}

void BasketPropertiesDialog::slotApply()
{
	m_properties->saveChanges();
	m_addPolicy->saveChanges();
	m_onClic->saveChanges();
	m_basket->save();

	if (AppSettings::tray)
		AppSettings::tray->updateToolTip();

	KDialogBase::slotApply();
}

void BasketPropertiesDialog::slotOk()
{
	slotApply();
	KDialogBase::slotOk();
}

#include "basketproperties.moc"
