/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMEDIT_H
#define ITEMEDIT_H

#include <qwidget.h>
#include <qtabdialog.h>

class QComboBox;
class QRadioButton;
class KColorButton;
class KColorCombo;
class KURLRequester;
class QCheckBox;
class QToolButton;
class KFontCombo;
class QTextEdit;
class QLineEdit;
class KIconButton;

class Item;
class IconSizeCombo;

/**A simple widget, that all Item content edit widget must inherit
  *for have various methods such as saveChanges() (must be reimplemented).
  *@author Sbastien Laot
  */

class ItemEditWidgetBase : public QWidget {
  Q_OBJECT
  public:
	ItemEditWidgetBase(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemEditWidgetBase();
  public slots:
	virtual void saveChanges();		// FIXME: Pure virtual
	virtual void goFirstFocus();
  private:
	virtual void doGoFirstFocus();

  protected:
	Item *m_item;
	bool  m_isAlreadyFirstFocused;
};

/**The widget to edit Text Item content.
  *@author Sbastien Laot
  */

class ItemTextEditWidget : public ItemEditWidgetBase {
  Q_OBJECT
  public:
	ItemTextEditWidget(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemTextEditWidget();
  public slots:
	void saveChanges();
  protected slots:
	void changeFont(int fontType);
	void changeColor(const QColor &color);
  private:
	virtual void doGoFirstFocus();

	QTextEdit   *m_text;
	KColorCombo *m_color;
	QComboBox   *m_font;
};

/**The widget to edit Html Item content.
  *@author Sbastien Laot
  */

class ItemHtmlEditWidget : public ItemEditWidgetBase {
  Q_OBJECT
  public:
	ItemHtmlEditWidget(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemHtmlEditWidget();
  public slots:
	void saveChanges();
  private slots:
	void slotShowSource(bool on);
	void slotChangeFont(const QString &font);
	void slotAlignLeft();
	void slotAlignCenter();
	void slotAlignRight();
	void slotAlignJustify();
	void cursorPositionChanged(int para, int pos);
	void untoggleAllAlign();
  private:
	virtual void doGoFirstFocus();

	QTextEdit   *m_text;
	KColorCombo *m_color;
	QCheckBox   *m_showHtmlSource;
	QWidget     *wid;

	KFontCombo  *m_font;
	QToolButton *m_tbi;
	QToolButton *m_tbb;
	QToolButton *m_tbu;
	QToolButton *m_tbal;
	QToolButton *m_tbac;
	QToolButton *m_tbar;
	QToolButton *m_tbaj;

	// QTextView : The text edit may be able to provide some meta-information.
	//  For example, the documentTitle() function will return the text from within HTML <title> tags.
};

/**The widget to edit Url Item content.
  *@author Sbastien Laot
  */

class ItemUrlEditWidget : public ItemEditWidgetBase {
  Q_OBJECT
  public:
	ItemUrlEditWidget(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemUrlEditWidget();
  public slots:
	void saveChanges();
  protected slots:
	void urlChanged(const QString&);
	void doNotAutoTitle(const QString&);
	void doNotAutoIcon(QString);
	void guessTitle();
	void guessIcon();
	void emptyIcon();
  private:
	virtual void doGoFirstFocus();

	bool           m_isAutoModified;
	KURLRequester *m_url;
	QLineEdit     *m_title;
	KIconButton   *m_icon;
	QPushButton   *m_autoTitle;
	QPushButton   *m_autoIcon;
};

/**The widget to edit Image Item content.
  *@author Sbastien Laot
  */

class ItemImageEditWidget : public ItemEditWidgetBase {
  Q_OBJECT
  public:
	ItemImageEditWidget(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemImageEditWidget();
  public slots:
	void saveChanges();
/*  protected slots:
	void chooseIcon();*/
  private:
	virtual void doGoFirstFocus();

	QPushButton   *m_edit;
/*	QPushButton   *m_chooseIcon;
	IconSizeCombo *m_iconSize;*/
};

/**The widget to edit Color Item content.
  *@author Sbastien Laot
  */

class ItemColorEditWidget : public ItemEditWidgetBase {
  Q_OBJECT
  public:
	ItemColorEditWidget(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemColorEditWidget();
  public slots:
	void saveChanges();
  private:
	virtual void doGoFirstFocus();

	KColorButton *m_color;
};

/**Widget to edit annotations of a Item, and check it.
  *@author Sbastien Laot
  */

class ItemEditWidget : public ItemEditWidgetBase {
  Q_OBJECT
  public:
	ItemEditWidget(Item *item, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemEditWidget();
  public slots:
	void saveChanges();
	void slotSelCommand();
  private:
	virtual void doGoFirstFocus();

	QCheckBox *m_checked;
	QTextEdit *m_annotations;
	QLineEdit *m_runCommand;
	QLineEdit *m_fileName;
};

/**Show a dialog with tabs to edit Item properties.
  *@author Sbastien Laot
  */

class ItemEditDialog : public QTabDialog {
  Q_OBJECT
  public:
	ItemEditDialog(Item *item, bool editAnnotations = false, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~ItemEditDialog();
  protected slots:
	void execGoFirstFocus(QWidget *page = 0);
	void apply();

  private:
	Item               *m_item;
	ItemEditWidgetBase *m_editContent;
	ItemEditWidget     *m_itemEdit;
};

#endif // ITEMEDIT_H
