/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LINKLABEL_H
#define LINKLABEL_H

class QString;
class KURL;
class QColor;
class QLabel;
class QBoxLayout;
class QSpacerItem;
class QPushButton;
class QCheckBox;
class QComboBox;
class KColorButton;

class IconSizeCombo;

#include <qframe.h>
#include <kapplication.h>

/**Store the style of links
  *@author Sbastien Laot
  */
class LinkLook
{
  public:
	LinkLook( bool underline = true, bool italic = false, bool bold = false, bool hoverUnder = true,
	          QColor color = QColor("blue"), QColor hoverColor = QColor("red"),
	          bool showIcon = true, int iconSize = 16, bool onTopIcon = false );
	void setLook( bool underline = true, bool italic = false, bool bold = false, bool hoverUnder = true,
	              QColor color = QColor("blue"), QColor hoverColor = QColor("red"),
	              bool showIcon = true, int iconSize = 16, bool onTopIcon = false );
	inline bool   underline()  { return m_underline;  }
	inline bool   italic()     { return m_italic;     }
	inline bool   bold()       { return m_bold;       }
	inline bool   hoverUnder() { return m_hoverUnder; }
	inline QColor color()      { return m_color;      }
	inline QColor hoverColor() { return m_hoverColor; }
	inline bool   showIcon()   { return m_showIcon;   }
	inline int    iconSize()   { return m_iconSize;   }
	inline bool   onTopIcon()  { return m_onTopIcon;  }
  private:
	bool   m_underline;
	bool   m_italic;
	bool   m_bold;
	bool   m_hoverUnder;
	QColor m_color;
	QColor m_hoverColor;
	bool   m_showIcon;
	int    m_iconSize;
	bool   m_onTopIcon;
  public:
	/* Global Looks */
	static LinkLook *localLook;
	static LinkLook *urlLook;
	static LinkLook *noUrlLook;
	/* Static method to get a LinkLook from an URL */
	static LinkLook* lookForURL(const KURL &url); // Item::ContentType type,
};

/**Used to represent links with icon and specific look
  *Note : This label will appear blank while LinkLook willn't be set
  *@author Sbastien Laot
  */
class LinkLabel : public QFrame
{
  Q_OBJECT
  public:
	LinkLabel(int hAlign, int vAlign, QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	LinkLabel(const QString &title, const QString &icon, LinkLook *look, int hAlign, int vAlign,
	          QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~LinkLabel();
  private:
	void initLabel(int hAlign, int vAlign);
  public:
	void setLink(const QString &title, const QString &icon, LinkLook *look = 0);
	void setLook(LinkLook *look);
	void setAlign(int hAlign, int vAlign);
  protected:
	void enterEvent(QEvent*);
	void leaveEvent(QEvent*);
  public:
	void setPaletteBackgroundColor(const QColor &color);

	QBoxLayout  *m_layout;
	QLabel      *m_icon;
	QLabel      *m_title;
	QSpacerItem *m_spacer1;
	QSpacerItem *m_spacer2;

	LinkLook    *m_look;
	int          m_hAlign;
	int          m_vAlign;
};

class LinkLookEditWidget : public QWidget
{
  Q_OBJECT
  public:
	LinkLookEditWidget(LinkLook *look, QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~LinkLookEditWidget();
	void saveChanges();
  private slots:
	void slotShowIcon(bool show);
  protected:
	LinkLook      *m_look;
	QPushButton   *m_underline;
	QPushButton   *m_italic;
	QPushButton   *m_bold;
	KColorButton  *m_color;
	KColorButton  *m_hoverColor;
	QCheckBox     *m_hoverUnder;
	QCheckBox     *m_showIcon;
	QWidget       *m_iconProperties;
	QComboBox     *m_onTopIcon;
	IconSizeCombo *m_iconSize;
};

#endif // LINKLABEL_H
