/*
* (c) 2004 Federico Poloni
*/

#include <stdlib.h>
#include <stdio.h>
#include <ncurses.h>

#include "game.h"
#include "bastet.h"
#include "bast.h"

#define WELL_POS(y,x) (*yx2pointer(y,x))


extern int bl_next;
extern char *well_data;
int *col_hei; //0..W+1, 0 and W+1 are the borders, cols start at 1
int *col_delta; //0..W: col_delta[0] is AFTER column 0
int *col_mult2; //0..W-1
#define col_mult (col_mult2-1)
//^^^small hack so that col_mult go from 1 (first column) to W (last)
//to be coherent with col_hei
int bl_points[BLOCK_TYPES]; //wantedness: higher if you *want* that block!

char debug_buf[100];

void bast_init()
{
  col_hei=(int *)malloc((WELL_WIDTH+2)*sizeof(int));
  col_hei[0]=col_hei[WELL_WIDTH+1]=1000; //"large enough"
  col_delta=(int *)malloc((WELL_WIDTH+1)*sizeof(int));
  col_mult2=(int *)malloc((WELL_WIDTH)*sizeof(int));
}

void calc_ratings()
{
  int i,j,meanhei;

  //fills in col_height & col_delta
  for(i=0;i<WELL_WIDTH;i++)
    {
      j=0;
      while(WELL_POS(j,i)==0 && j<WELL_HEIGHT) j++;
      col_hei[i+1]=WELL_HEIGHT-j;
    }
  for(i=0;i<=WELL_WIDTH;i++)
    col_delta[i]=col_hei[i+1]-col_hei[i];

  //evaluates column multipliers based on mean height
  meanhei=0;
  for(i=1;i<=WELL_WIDTH;i++) meanhei+=col_hei[i];
  meanhei/=WELL_WIDTH; //integer division
  for(i=1;i<=WELL_WIDTH;i++)
    {
      int dh=col_hei[i]-meanhei;
      const int mults[]={80,80,75,70,70, 65, 20,20,15,15,10};
      if(dh<-5) //line is LOW
        col_mult[i]=100;
      else if (dh>5) //line is HIGH
        col_mult[i]=5;
      else col_mult[i]=mults[dh+5];
			
			//columns that are "locally" (i.e. relative to their neighbours) low get a bonus (that's the ones you do normally want to complete rows)
			if(dh<=0 && col_hei[i]<col_hei[i+1] && col_hei[i]<=col_hei[i-1])
				col_mult[i]+=10;
			if(dh<=0 && col_hei[i]<col_hei[i-1] && col_hei[i]<=col_hei[i+1])
				col_mult[i]+=10;
    }

  //single-piece job

#define MAX(a,b) (a>b?a:b)
#define BL_CALC(type,score) {bl_points[type]=MAX(bl_points[type],score);}

  for(i=0;i<BLOCK_TYPES;i++)
  {
	  bl_points[i]=0;
  }

	//COLUMN LOOP:
	for(i=0;i<=WELL_WIDTH;i++)
		{
			//BL_I: is the easiest:
			//canyon:
	    if(col_delta[i]<=-3 && col_delta[i+1]>=3) 
				BL_CALC(BL_I,200);
			
			//good placement (2 or more of delta)
			if (col_delta[i]>=2) 
				BL_CALC(BL_I,col_mult[i]);
			if (col_delta[i]<=-2) 
	                	BL_CALC(BL_I,col_mult[i+1]);
			if(col_delta[i]<=-1 && col_delta[i+1]>=1)
				BL_CALC(BL_I,col_mult[i+1]);
			

			//horizontally:
			if(col_delta[i]==0 && col_delta[i+1]==0 && col_delta[i+2]==0) {
				BL_CALC(BL_I,(col_mult[i]+col_mult[i+3])/2);
			}
			//BL_O (with BL_J and BL_L)
			if(col_delta[i]==0) {
				BL_CALC(BL_O,(col_mult[i]+col_mult[i+1])/2);
				BL_CALC(BL_J,(col_mult[i]+col_mult[i+1])/2);
				BL_CALC(BL_L,(col_mult[i]+col_mult[i+1])/2);
			}
			//BL_J:
			//facing down:
			if(col_delta[i]==2) {
				BL_CALC(BL_J,col_mult[i]);
			}
			//horizontally (spike down)
			if(col_delta[i]==0 && col_delta[i+1]==-1) {
				BL_CALC(BL_J,col_mult[i+2]);
			}
			//horizontally(spike up): handled separately, with T
			//J-like: handled separately with O
			
			//BL_L is specular
			if(col_delta[i]==-2) {
				BL_CALC(BL_L,col_mult[i+1]);
			}
			if(col_delta[i]==1 && col_delta[i+1]==0) {
				BL_CALC(BL_L,col_mult[i]);
			}
			
			//BL_Z:
			//vert.
			if(col_delta[i]==1)
				{
					BL_CALC(BL_Z,col_mult[i]);
					BL_CALC(BL_T,col_mult[i]);
				}
			//hor.
			else if(col_delta[i]==-1 && col_delta[i+1]==0)
				{
					BL_CALC(BL_Z,col_mult[i+2]);
				}

			//BL_S specular:
			if(col_delta[i]==-1) {
				BL_CALC(BL_S,col_mult[i+1]);
				BL_CALC(BL_T,col_mult[i+1]);
			}
			//hor.
			else if(col_delta[i]==0 && col_delta[i+1]==1) {
				BL_CALC(BL_S,col_mult[i]);
			}

			//BL_T: vertically, handled with BL_S & BL_Z.
			//horizontally: spike down:
			if(col_delta[i]==-1 && col_delta[i+1]==1) {
				BL_CALC(BL_T,col_mult[i+1]);
			}
			//spike up (together with L and J):
			if(col_delta[i]==0 && col_delta[i+1]==0) {
				BL_CALC(BL_J,(col_mult[i]+col_mult[i+2])/2);
				BL_CALC(BL_L,(col_mult[i]+col_mult[i+2])/2);
				BL_CALC(BL_T,(col_mult[i]+col_mult[i+2])/2);
			}

		} //end column loop

	//EXECUTED ONCE:
	
	//score falls down if not found!
	{
		//IOJLSZT
		const int i_score[]={-50,-90,-80,-80,-90,-90,-50};
		for(i=0;i<BLOCK_TYPES;i++)
			if(bl_points[i]==0)
				bl_points[i]=i_score[i];
	}

	//perturbe score (-2 to +2), to avoid stupid tie handling
        for(i=0;i<BLOCK_TYPES;i++)
		  bl_points[i]+=random() % 5 - 2;
	
  //DEBUG STUFF:
				//snprintf(debug_buf,100,"col_heis 019A:%d %d %d %d                  ",
							 // col_hei[0],col_hei[1],col_hei[9],col_hei[10]);
				//   col_mult[1],col_mult[2],col_mult[9],col_mult[10]);
  //     bl_points[BL_J],bl_points[BL_L],bl_points[BL_Z],meanhei);

  snprintf(debug_buf,100,"I:%3d O:%3d J:%3d L:%3d Z:%3d S:%3d T:%3d              ",
           bl_points[BL_I],bl_points[BL_O],bl_points[BL_J],bl_points[BL_L],
					            bl_points[BL_Z],bl_points[BL_S],bl_points[BL_T]);

  mvaddstr(0,0,debug_buf);
  wrefresh(stdscr);
}


int qsort_compar_func (const void* a, const void *b)
{
  int ia=*((char*)a);
  int ib=*((char*)b);
  if (bl_points[ia]==bl_points[ib]) return 0;
  else if (bl_points[ia]<bl_points[ib]) return -1;
  else return 1;
}


int choose_piece()
{
  char bl_sort[BLOCK_TYPES];
  int i,rnd;
  const int bl_percent[BLOCK_TYPES]={82,88,94,100,100,100,100};

  calc_ratings();
  //return random() % BLOCK_TYPES;

  for(i=0;i<BLOCK_TYPES;i++) bl_sort[i]=i;
  qsort(bl_sort,BLOCK_TYPES,sizeof(char),&qsort_compar_func);

  bl_next=bl_sort[BLOCK_TYPES-1];
  
  rnd=random()%100; //0..99
  for(i=0;i<BLOCK_TYPES;i++)
    {
      if(rnd<bl_percent[i])
        return bl_sort[i];
    }
  return bl_sort[0]; //should not arrive here
}
