// Copyright (C) 2002 David Kerry.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne
// with the Aculab telephony libraries to produce a executable image
// without requiring Aculab's libraries to be supplied in a free software
// license as long as each source file so linked contains this exclusion
// and the unaltered Aculab source files are made available.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".


#include "driver.h"

#ifdef    CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

bool AculabTrunk::ringHandler(TrunkEvent *event)
{
	char script[256];
	char *args[2];
	char **start = NULL;
	TrunkGroup *grp = NULL;
	struct cause_xparms cause;
	struct detail_xparms detail_xparms;
	char cid[128];


slog(Slog::levelDebug) <<name<<": ringHandler event "<<event->id<<endl;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		/*
		 * An incoming call has been detected.
		 * At this point, all the information we need should already
		 * be available (ANI/DNIS/etc) (true for T1?)
		 */
		enterState("ring");
		status[id] = '!';

		detail_xparms.valid=0;
		detail_xparms.handle=handle;
		detail_xparms.timeout=500;
		if (call_details(&detail_xparms)) {
			slog(Slog::levelError) <<name<<": error retrieving call details"
					<< endl;
			return false;
		}

		slog(Slog::levelInfo) <<name<<": call details:"<<endl;
		aculabivr.dumpCallDetail(&detail_xparms);

		if (*detail_xparms.originating_addr) {
			sprintf(cid,"pstn:%s",detail_xparms.originating_addr);
			setConst(SYM_CALLER, (char *)cid);
			setConst(SYM_ANI, detail_xparms.originating_addr);
		}

		sprintf(cid,"pstn:%s",detail_xparms.destination_addr);
		setConst(SYM_DIALED, (char *)cid);
		setConst(SYM_DNIS, detail_xparms.destination_addr);

		if (!group->getAccept()) {
			slog(Slog::levelError) <<name<<": rejecting incoming call"<<endl;
			cause.handle=handle;
			cause.cause=0;
			cause.raw=0;
			call_disconnect(&cause);
			handler=&AculabTrunk::idleHandler;
			return true;
		}
		Trunk::flags.dsp = DSP_MODE_CALLERID;
		rings++;

	case TRUNK_RINGING_OFF:
		if(rings > 1)
			Trunk::flags.dsp = DSP_MODE_INACTIVE;

		sprintf(script, "ring%d", event->parm.ring.digit);
		if(!grp)
			grp = group;

		start = getInitial(args);
		if(attach(*start)) {
			setList(++start);
			exittimer = 0;
			handler = &AculabTrunk::stepHandler;
			return true;
		}
		slog(Slog::levelError) << name<< ": cannot answer call" << endl;
		if (rings > 1) {
			slog(Slog::levelError) << name << ": clearing unanswerable call"<<endl;
			handler=&AculabTrunk::hangupHandler;
		}
		rings = 0;
		return true;
	case TRUNK_LINE_WINK:
	case TRUNK_START_SCRIPT:
		return false;
	case TRUNK_RING_START:
		Trunk::flags.dsp = DSP_MODE_INACTIVE;
		return idleHandler(event);
	case TRUNK_RINGING_ON:
		++rings;
		endTimer();
		return true;
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_TIMER_EXPIRED:
		Trunk::flags.dsp = DSP_MODE_INACTIVE;
		handler = &AculabTrunk::idleHandler;
		return true;
	}
	return false;
}

#ifdef    CCXX_NAMESPACES
};
#endif
