// Copyright (C) 2006 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// Portions originally generated by mib2c

// Necessary libraries
#include <algorithm>
#include <bayonne.h>
#include <cc++/thread.h>
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#ifndef SYM_TRUNKID // Hack to ensure that this Bayonne include file is not included twice
#include <server.h>
#endif // SYM_TRUNKID
#include "snmpsubagent.h"
#include "snmpsubagent_routines.h"
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>

#ifdef  CCXX_NAMESPACES
using namespace ost;
using namespace std;
#endif

// To make the snmp class available to other modules, as well as net-snmp functions
SNMPSubAgent snmp;

SNMPSubAgent::SNMPSubAgent( ) : Monitor( ), Server( keythreads.priService( ) )
{ // Start of SNMPSubAgent::SNMPSubAgent( )
	//////////////////
	// Initialization
	//////////////////
	ulShortest = 0;
	ulLongest = 0;
	ulTotal = 0;

	// Thread specific initialization
	setCancel( cancelDeferred );
	setSuspend( suspendDisable );
	setException( throwNothing );
} // End of SNMPSubAgent::SNMPSubAgent( )

SNMPSubAgent::~SNMPSubAgent( )
{ // Start of SNMPSubAgent::~SNMPSubAgent( )
	//////////////////////////////////////
	// Destroy any remnants of the thread
	//////////////////////////////////////
	terminate( );

	///////////
	// Cleanup
	///////////
	lcmState.clear( );
	muiulCount.clear( );
	suiActive.clear( );
} // End of SNMPSubAgent::~SNMPSubAgent( )

void SNMPSubAgent::initial( )
{ // Start of SNMPSubAgent::initial( )
	////////////////////////
	// Variable declaration
	////////////////////////
	netsnmp_handler_registration*	pnhrStatus;
	netsnmp_variable_list*		pnsvlTrapstart;
	char*				pcParam;
	oid				oBayStatus[ ]		= { SNMP_OID_BAYONNE_STATUS };
	oid				oBayHost[ ]		= { SNMP_OID_BAYONNE_STATUS, static_cast<oid>( bayHost ) };
	oid				oBayDriver[ ]		= { SNMP_OID_BAYONNE_STATUS, static_cast<oid>( bayDriver ) };
	oid				oBayVersion[ ]		= { SNMP_OID_BAYONNE_STATUS, static_cast<oid>( bayVersion ) };
	oid				oBayStartTrap[ ]	= { SNMP_OID_BAYONNE_TRAP_STARTED };
	oid				oSnmpTrap[ ]		= { SNMP_OID_NOTIFICATION };
	struct timezone			stzUseless;

	//////////////////
	// Initialization
	//////////////////
	pnsvlTrapstart = NULL;

	// Accurate start of this system; As its only
	// initialized here resource locking is not necessary
	gettimeofday( &stvBoot, &stzUseless );

	// Log errors to syslog
	snmp_enable_calllog();

	// Indicate capability; SNMP sub-agent, AgentX protocol
	netsnmp_ds_set_boolean( NETSNMP_DS_APPLICATION_ID, NETSNMP_DS_AGENT_ROLE, 1 );

	// Initialize the agent itself
	SOCK_STARTUP;
	init_agent( "GNUBayonne" );

	// Register the handlers
	pnhrStatus = netsnmp_create_handler_registration( "bayStatus",
	                                                  bayStatus_handler,
	                                                  oBayStatus,
	                                                  OID_LENGTH( oBayStatus ),
       							  HANDLER_CAN_RONLY );
	if ( !initialize_table_bayLineTable( ) || ( pnhrStatus == NULL ) )
	{
		slog( Slog::levelNotice ) << "snmpsubagent: Cannot initialize agent; handler registration failure" << endl;
		return;
	} // End of if

	netsnmp_register_scalar_group( pnhrStatus, static_cast<oid>( bayHost ), static_cast<oid>( bayLastCall ) );

	// Net-SNMP specific configuration for Bayonne
	init_snmp( "GNUBayonne" );

	///////////////////////////
	// Send out the start trap
	///////////////////////////
	snmp_varlist_add_variable( &pnsvlTrapstart,
	                           oSnmpTrap,
	                           OID_LENGTH( oSnmpTrap ),
	                           ASN_OBJECT_ID,
	                           reinterpret_cast<const u_char*>( oBayStartTrap ),
	                           OID_LENGTH( oBayStartTrap ) * sizeof ( oid ) );

	pcParam = const_cast<char*>( keyserver.getNode( ) );
	snmp_varlist_add_variable( &pnsvlTrapstart,
	                           oBayHost,
	                           OID_LENGTH( oBayHost ),
	                           ASN_OCTET_STR,
	                           reinterpret_cast<const u_char*>( pcParam ),
	                           strlen( pcParam ) );

	pcParam = const_cast<char*>( plugins.getDriverName( ) );
	snmp_varlist_add_variable( &pnsvlTrapstart,
	                           oBayDriver,
	                           OID_LENGTH( oBayDriver ),
	                           ASN_OCTET_STR,
	                           reinterpret_cast<const u_char*>( pcParam ),
	                           strlen( pcParam ) );

	pcParam = const_cast<char*>( getenv( "SERVER_VERSION" ) );
	snmp_varlist_add_variable( &pnsvlTrapstart,
	                           oBayVersion,
	                           OID_LENGTH( oBayVersion ),
	                           ASN_OCTET_STR,
	                           reinterpret_cast<const u_char*>( pcParam ),
	                           strlen( pcParam ) );
	this->addTrap( pnsvlTrapstart );

	/////////////////
	// Signon header
	/////////////////
	slog( Slog::levelNotice ) << "snmpsubagent: Agent initialized" << endl;
} // End of SNMPSubAgent::initial( )

void SNMPSubAgent::run( )
{ // Start of SNMPSubAgent::run( )
	////////////////////////
	// Variable declaration
	////////////////////////
	int			iFDCount;
	int			iBlock;
	fd_set			fsSNMP;
	struct timeval		stvDefault;
	struct timeval		stvTimeout;
	netsnmp_variable_list*	pnsvlTrap;

	//////////////////
	// Initialization
	//////////////////
	stvDefault.tv_sec = SNMP_SELECT_TIMEOUT / 1000000;
	stvDefault.tv_usec = SNMP_SELECT_TIMEOUT % 1000000;

	///////////////////////////
	// Main SNMP handling loop
	///////////////////////////
	// Net-SNMP states that its usage is not thread-safe, so most
	// access to its functions is locked by a Mutex, just to be safe
	while ( !testCancel( ) )
	{
		// Transmit any traps; see SNMPSubAgent::processTraps( ) for details
		this->processTraps( );

		// See if there's any new requests from the master to handle
		iFDCount = 0;
		FD_ZERO( &fsSNMP );
		stvTimeout = stvDefault;
		iBlock = 0;
		enterMutex( );
		snmp_select_info( &iFDCount, &fsSNMP, &stvTimeout, &iBlock );
		leaveMutex( );

		// A block indicated by Net-SNMP seems to indicate that block is
		// allowed as far as Net-SNMP is concerned; aka nothing to do
		// Of course this never happens as this might lockup Bayonne
		if ( timercmp( &stvTimeout, &stvDefault, > ) || iBlock )
		{
			// Do some load redux instead
			yield( );
			stvTimeout = stvDefault;
		} // End of if

		switch ( select( iFDCount, &fsSNMP, NULL, NULL, &stvTimeout ) )
		{
			case	-1:	// Error
				slog( Slog::levelNotice ) << "snmpsubagent: critical error during select( )" << endl;
				return;

			case	0:	// Timeout; Nothing to do
				enterMutex( );
				snmp_timeout( );
				leaveMutex( );
				break;

			default:	// New information from the master to process
				enterMutex( );
				snmp_read( &fsSNMP );
				leaveMutex( );
				break;
		} // End of switch
	} // End of while
} // End of SNMPSubAgent::run( )

void SNMPSubAgent::final( )
{ // Start of SNMPSubAgent::final( )
	////////////////////////
	// Variable declaration
	////////////////////////
	char*			pcParam;
	netsnmp_variable_list*	pnsvlTrapend;
	oid			oBayHost[ ]		= { SNMP_OID_BAYONNE_STATUS, static_cast<oid>( bayHost ) };
	oid			oBayDriver[ ]		= { SNMP_OID_BAYONNE_STATUS, static_cast<oid>( bayDriver ) };
	oid			oBayVersion[ ]		= { SNMP_OID_BAYONNE_STATUS, static_cast<oid>( bayVersion ) };
	oid			oBayEndedTrap[ ]	= { SNMP_OID_BAYONNE_TRAP_ENDED };
	oid			oSnmpTrap[ ]		= { SNMP_OID_NOTIFICATION };

	///////////////////
	// Notify the user
	///////////////////
	slog( Slog::levelNotice ) << "snmpsubagent: Agent shutting down" << endl;

	//////////////////////////////
	// Send out the shutdown trap
	//////////////////////////////
	pnsvlTrapend = NULL;
	snmp_varlist_add_variable( &pnsvlTrapend,
	                           oSnmpTrap,
	                           OID_LENGTH( oSnmpTrap ),
	                           ASN_OBJECT_ID,
	                           reinterpret_cast<const u_char*>( oBayEndedTrap ),
	                           OID_LENGTH( oBayEndedTrap ) * sizeof ( oid ) );

	pcParam = const_cast<char*>( keyserver.getNode( ) );
	snmp_varlist_add_variable( &pnsvlTrapend,
	                           oBayHost,
	                           OID_LENGTH( oBayHost ),
	                           ASN_OCTET_STR,
	                           reinterpret_cast<const u_char*>( pcParam ),
	                           strlen( pcParam ) );

	pcParam = const_cast<char*>( plugins.getDriverName( ) );
	snmp_varlist_add_variable( &pnsvlTrapend,
	                           oBayDriver,
	                           OID_LENGTH( oBayDriver ),
	                           ASN_OCTET_STR,
	                           reinterpret_cast<const u_char*>( pcParam ),
	                           strlen( pcParam ) );

	pcParam = const_cast<char*>( getenv( "SERVER_VERSION" ) );
	snmp_varlist_add_variable( &pnsvlTrapend,
	                           oBayVersion,
	                           OID_LENGTH( oBayVersion ),
	                           ASN_OCTET_STR,
	                           reinterpret_cast<const u_char*>( pcParam ),
	                           strlen( pcParam ) );
	this->addTrap( pnsvlTrapend );

	////////////////////////////////
	// Transmit any remaining traps
	////////////////////////////////
	this->processTraps( );

	/////////////////////////////
	// Net-SNMP specific cleanup
	/////////////////////////////
	snmp_shutdown( "GNUBayonne" );
	SOCK_CLEANUP;
} // End of SNMPSubAgent::final( )

void SNMPSubAgent::monitorState( Trunk* ptLine, char* pcState )
{ // Start of SNMPSubAgent::monitorState( Trunk*, char* )
	////////////////////////
	// Variable declaration
	////////////////////////
	unsigned int	uiPort;

	///////////////////////////////////
	// Check for call progress changes
	///////////////////////////////////
	uiPort = ptLine->getId( );
	if ( !( strcmp( pcState, "answer" ) || this->OffHook( uiPort ) ) )
	{
		this->Answer( ptLine );
	}
	else if ( !strcmp( pcState, "hangup" ) )
	{
		this->Hangup( ptLine );
	} // End of if
} // End of SNMPSubAgent::monitorState( Trunk*, char* )

struct timeval SNMPSubAgent::LastCall( )
{ // Start of SNMPSubAgent::LastCall( )
	////////////////////////
	// Variable declaration
	////////////////////////
	lastcallmap::iterator	lcmiMax;
	MutexLock		mlCall( *this );

	//////////////////////////////////////////////////////////////
	// Same as LastCall( unsigned int ), but now across all ports
	//////////////////////////////////////////////////////////////
	lcmiMax = max_element( lcmState.begin( ), lcmState.end( ), lcm_cmp );
	return ( getGroup( NULL )->getStat( STAT_SYS_ACTIVITY ) ? lcmiMax->second : Boot( ) );
} // End of SNMPSubAgent::LastCall( )

void  SNMPSubAgent::SetLastCall( unsigned int uiPort )
{ // Start of SNMPSubAgent::SetLastCall( unsigned int )
	////////////////////////
	// Variable declaration
	////////////////////////
	struct timezone		stzUseless;
	MutexLock		mlCall( *this );

	gettimeofday( &( lcmState[ uiPort ] ), &stzUseless );	// Start of call
} // End of SNMPSubAgent::SetLastCall( unsigned int )

void SNMPSubAgent::UpdateDuration( u_long ulDuration )
{ // Start of SNMPSubAgent::UpdateDuration( u_long )
	enterMutex( );
	if ( ulDuration > ulLongest )
	{
		ulLongest = ulDuration;
	} // End of if

	if ( ( ulDuration < ulShortest ) || ( ( !ulShortest ) && ( ulDuration > 0 ) ) )
	{
		ulShortest = ulDuration;

	} // End of if

	ulTotal += ulDuration;
	leaveMutex( );
} // End of SNMPSubAgent::UpdateDuration( u_long )

bool SNMPSubAgent::OffHook( unsigned int uiPort, bool bState )
{ // Start of SNMPSubAgent::OffHook( unsigned int, bool )
	////////////////////////
	// Variable declaration
	////////////////////////
	MutexLock	mlHook( *this );

	if ( bState )
	{
		suiActive.insert( uiPort );
	}
	else
	{
		suiActive.erase( uiPort );
	} // End of if

	return bState;
} // End of SNMPSubAgent::OffHook( unsigned int, bool )

void SNMPSubAgent::Answer( Trunk* ptLine )
{ // Start of SNMPSubAgent::Answer( Trunk* )
	////////////////////////
	// Variable declaration
	////////////////////////
	oid			oBayCallStartTrap[ ]	= { SNMP_OID_BAYONNE_TRAP_CALLSTART };
	oid			oBayLineTable[]		= { SNMP_OID_BAYONNE_LINE_TABLE, 1, 0, 0 }; // Last 2 values purposefully left empty
	oid			oSnmpTrap[ ]		= { SNMP_OID_NOTIFICATION };
	netsnmp_variable_list*	pnsvlCall;
	size_t			stSize;
	unsigned int		uiPort;

	//////////////////
	// Initialization
	//////////////////
	uiPort = ptLine->getId( );
	pnsvlCall = NULL;

	/////////////////////
	// Update port state
	/////////////////////
	this->OffHook( uiPort, true );
	this->SetLastCall( uiPort );


	//////////////////////////////////////////
	// Notify the system by scheduling a trap
	//////////////////////////////////////////
	snmp_varlist_add_variable( &pnsvlCall,				// Notification OID
	                           oSnmpTrap,
	                           OID_LENGTH( oSnmpTrap ),
	                           ASN_OBJECT_ID,
	                           reinterpret_cast<const u_char*>(  oBayCallStartTrap ),
	                           OID_LENGTH( oBayCallStartTrap ) * sizeof ( oid ) );

	oBayLineTable[ 10 ] = uiPort;					// Table index number
	oBayLineTable[ 9 ] = static_cast<oid>( bayColIndex );		// Table column (line)
	snmp_varlist_add_variable( &pnsvlCall,
	                           oBayLineTable,
	                           OID_LENGTH( oBayLineTable ),
	                           ASN_INTEGER,
	                           reinterpret_cast<const u_char*>( &uiPort ),
	                           sizeof ( unsigned int ) );

	oBayLineTable[ 9 ] = static_cast<oid>( bayColANI );		// Table column (ANI)
	const u_char* pucANI = getBaySymbol( SYM_CLID, ptLine, &stSize );
	snmp_varlist_add_variable( &pnsvlCall, oBayLineTable, OID_LENGTH( oBayLineTable ), ASN_OCTET_STR, pucANI, stSize );

	oBayLineTable[ 9 ] = static_cast<oid>( bayColDNIS );		// Table column (DNIS)
	const u_char* pucDNIS = getBaySymbol( SYM_DNID, ptLine, &stSize );
	snmp_varlist_add_variable( &pnsvlCall, oBayLineTable, OID_LENGTH( oBayLineTable ), ASN_OCTET_STR, pucDNIS, stSize );

	oBayLineTable[ 9 ] = static_cast<oid>( bayColName );		// Table column (NAME)
	const u_char* pucName = getBaySymbol( SYM_NAME, ptLine, &stSize );
	snmp_varlist_add_variable( &pnsvlCall, oBayLineTable, OID_LENGTH( oBayLineTable ), ASN_OCTET_STR, pucName, stSize );

	// Send out the trap
	this->addTrap( pnsvlCall );
} // End of SNMPSubAgent::Answer( Trunk* )

void SNMPSubAgent::Hangup( Trunk* ptLine )
{ // Start of SNMPSubAgent::Hangup( Trunk* )
	////////////////////////
	// Variable declaration
	////////////////////////
	oid			oBayCallEndTrap[ ]	= { SNMP_OID_BAYONNE_TRAP_CALLEND };
	oid			oBayLineTable[]		= { SNMP_OID_BAYONNE_LINE_TABLE, 1, 0, 0 }; // Last 2 values purposefully left empty
	oid			oSnmpTrap[ ]		= { SNMP_OID_NOTIFICATION };
	netsnmp_variable_list*	pnsvlCall;
	struct timeval		stvStart;
	u_long			ulCalls;
	u_long			ulDuration;
	size_t			stSize;
	unsigned int		uiPort;

	//////////////////
	// Initialization
	//////////////////
	uiPort = ptLine->getId( );
	pnsvlCall = NULL;
	ulDuration = 0;

	//////////////////////////////
	// Update internal statistics
	//////////////////////////////
	// Call count; not done during call start because average will be incorrect
	ulCalls = static_cast<u_long>( this->UpdateCallCount( uiPort ) );

	// Calculate duration (Call count is important for the duration during the first call)
	stvStart = this->LastCall( uiPort );
	if ( timerisset( &stvStart ) )
	{
		// In the event a call was made without being actually established
		ulDuration = timeval_tticks( &stvStart );
		this->UpdateDuration( ulDuration );
	} // End of if

	// Update port state
	this->OffHook( uiPort, false );

	//////////////////////////////////////////
	// Notify the system by scheduling a trap
	//////////////////////////////////////////
	snmp_varlist_add_variable( &pnsvlCall,
	                           oSnmpTrap,
	                           OID_LENGTH( oSnmpTrap ),
	                           ASN_OBJECT_ID,
	                           reinterpret_cast<const u_char*>( oBayCallEndTrap ),
	                           OID_LENGTH( oBayCallEndTrap ) * sizeof ( oid ) );

	oBayLineTable[ 10 ] = uiPort;					// Table index number
	oBayLineTable[ 9 ] = static_cast<oid>( bayColIndex );		// Table column (line)
	snmp_varlist_add_variable( &pnsvlCall,
	                           oBayLineTable,
	                           OID_LENGTH( oBayLineTable ),
	                           ASN_INTEGER,
	                           reinterpret_cast<const u_char*>( &uiPort ),
	                           sizeof ( unsigned int ) );

	oBayLineTable[ 9 ] = static_cast<oid>( bayColDuration );	// Table column (duration)
	snmp_varlist_add_variable( &pnsvlCall,
	                           oBayLineTable,
	                           OID_LENGTH( oBayLineTable ),
	                           ASN_TIMETICKS,
	                           reinterpret_cast<const u_char*>( &ulDuration ),
	                           sizeof ( unsigned long ) );

	oBayLineTable[ 9 ] = static_cast<oid>( bayColTotal );		// Table column (call count)
	snmp_varlist_add_variable( &pnsvlCall,
	                           oBayLineTable,
	                           OID_LENGTH( oBayLineTable ),
	                           ASN_COUNTER,
	                           reinterpret_cast<const u_char*>( &ulCalls ),
	                           sizeof ( u_long ) );

	// Send out the trap
	this->addTrap( pnsvlCall );
} // End of SNMPSubAgent::Hangup( Trunk* )

void SNMPSubAgent::processTraps( )
{ // Start of void SNMPSubAgent::processTraps( )
	////////////////////////
	// Variable declaration
	////////////////////////
	netsnmp_variable_list*	pnsvlTrap;

	/////////////////
	// Process traps
	/////////////////
	// The reason why the Answer and Hangup methods do
	// not directly call send_v2trap is that this can
	// cause threading deadlock (and will!)
	while ( this->hasTrap( ) )
	{
		pnsvlTrap = this->getTrap( );

		enterMutex( );
		send_v2trap( pnsvlTrap );

		snmp_free_varbind( pnsvlTrap );
		leaveMutex( );

	} // End of while
} // End of void SNMPSubAgent::processTraps( )
