/***************************************************************************
                         -- font.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include <qlabel.h>
#include <qfontdialog.h>
#include <qgrid.h>
#include <qlayout.h>

#include "font.h"

// font selector implementation.
// 
FontSelector::FontSelector( QWidget *parent, const char *name )
		: QWidget(  parent, name )
{
	resize( 596, 480 );

	QHBoxLayout *layout = new QHBoxLayout( this ); 
	layout->setSpacing( 6 );
	layout->setMargin( 0 );
	
	QLabel *tl1 = new QLabel( this, "tl1" );
	tl1->setText( tr( "Font:" ) );
	layout->addWidget( tl1 );
	
	lineedit = new QLineEdit( this, "lineedit" );
	layout->addWidget( lineedit );
	
	button = new QPushButton( this, "button" );
	button->setText( tr( "..." ) );
	layout->addWidget( button );
	
	QLabel *tl2 = new QLabel( this, "tl2" );
	tl2->setText( tr( "Justify:" ) );
	layout->addWidget( tl2 );
	
	justify = new QComboBox( FALSE, this, "justify" );
	justify->insertItem( tr( "Left" ) );
	justify->insertItem( tr( "Center" ) );
	justify->insertItem( tr( "Right" ) );
	layout->addWidget( justify );
	
	connect( button, SIGNAL( clicked() ), this, SLOT( doFontSelect() ) );
	
	connect( justify, SIGNAL( activated(int) ), this, SLOT( modified() ) );
}	

FontSelector::~FontSelector()
{
	delete button;
	delete justify;
	delete lineedit;
}

void FontSelector::doFontSelect()
{
	bool ok;
	QFont font;

	if (lineedit->text().length())  
		font.setRawName( lineedit->text() );

	QFont tmpFnt;
	
	tmpFnt = QFontDialog::getFont( &ok, font );	
	if ( ok ) {
		lineedit->setText( tmpFnt.rawName() );
		lineedit->setCursorPosition( 0 );
		modified();
	}
}

void FontSelector::modified()
{
	changed();
}

