/***************************************************************************
                         -- tb_main.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "tb_main.h"
#include "qlabel.h"
#include "qpushbutton.h"
#include "qfiledialog.h"
#include "qtextstream.h"

#include "vr_filepreview.h"

// --------------------------------------------------------------- //

/* 
 *  Constructs a ToolboxMain which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
ToolboxMain::ToolboxMain( QWidget* parent,  const char* name, WFlags fl )
    : ToolboxMainBase( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ToolboxMain::~ToolboxMain()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void ToolboxMain::style_open()
{
	QString styledir = style_current->text().left( 
			style_current->text().findRev("/") );

	QString file;
	QFileDialog *fd = new QFileDialog ( QString::null, "Styles (*)", this, 0, TRUE );
	fd->setContentsPreviewEnabled( TRUE );
	MyPreview* p = new MyPreview(fd);     
	fd->setContentsPreview( p, p );
	fd->setViewMode( QFileDialog::List );
	fd->setPreviewMode( QFileDialog::Contents );
	fd->setCaption( "Select Style File to Open");
	fd->setMode( QFileDialog::ExistingFile );
	fd->setShowHiddenFiles(true);
	fd->setDir( styledir );

	if ( fd->exec() == QDialog::Accepted ) {
        	file = fd->selectedFile();
		emit open_new(file);
	}
    
}
/* 
 * public slot
 */
void ToolboxMain::style_save_as()
{
	QString styledir = style_current->text().left( 
			style_current->text().findRev("/") );

	QString file;
	MyPreview* p = new MyPreview;     
	QFileDialog* fd = new QFileDialog( styledir, "Styles (*)", this, "w", true );
	fd->setContentsPreviewEnabled( TRUE );
	fd->setContentsPreview( p, p );
	fd->setMode( QFileDialog::AnyFile );
	fd->setDir( styledir );
	fd->setCaption( "Select Style File to Save As");
	fd->setPreviewMode( QFileDialog::Contents );

	if ( fd->exec() == QDialog::Accepted ) {
        	file = fd->selectedFile();
		emit save_as(file);
	}
}

void ToolboxMain::loadFile(QString style) 
{
	style_current->setText(style);
}

