/***************************************************************************
                         -- themes.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "themes.h"

#include <stdlib.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <iostream>

#include <X11/Xlib.h>
#include <X11/Xatom.h>

extern "C" class themes *maker(const QDict<QString> args) {
	return new class themes(0, "Plugin_Themes", args);
}

themes::themes(QObject *o, const char *c, const QDict<QString> args) : Plugin(o, c) {

	if (QString* loadfile = args["loadfile"] ) {
		m_configfile = expandTilde(loadfile->latin1());
	} else {
		m_configfile = "";
	}

	// set widgets
	TreeNode<QWidget> *t = new TreeNode<QWidget>;
	TreeNode<QWidget> *created;

	t->setObject(widget_main =  new ToolboxMain);
	connect(t->object(), SIGNAL(open_new(const QString)), 
			this, SLOT(open_new(const QString)));
	connect(t->object(), SIGNAL(save_as(const QString)), 
			this, SLOT(save_as(const QString)));
	created = tree->insert(t);

	t->setObject(widget_misc =  new ToolboxMisc);
	connect(t->object(), SIGNAL(changed()), this, SLOT(setIsModified()));
	created = created->child()->insert(t);

	t->setObject(widget_menu =  new ToolboxMenu);
	connect(t->object(), SIGNAL(changed()), this, SLOT(setIsModified()));
	created = created->insert(t);

	t->setObject(widget_window =  new ToolboxWindow);
	connect(t->object(), SIGNAL(changed()), this, SLOT(setIsModified()));
	created = created->insert(t);

	t->setObject(widget_toolbar = new ToolboxToolbar);
	connect(t->object(), SIGNAL(changed()), this, SLOT(setIsModified()));
	created = created->insert(t);

	delete t;

	if (! m_configfile.length() >0 ) {

		m_configfile = "Couldn't find style file.";

		// try to load the current style file (from blackbox's ~/.blackboxrc)
  		XrmDatabase db;
		QString blackboxrc;
		blackboxrc = getenv ("HOME");
		blackboxrc.append("/.blackboxrc");

		db = XrmGetFileDatabase( blackboxrc );
		if ( db ) {
			XrmValue value;
			char *value_type;

			if (XrmGetResource(db, "session.styleFile", "Session.StyleFile", 
						&value_type, &value)) {
				m_configfile = expandTilde((const char *) value.addr);
			}
		}
	}

	load();
}

void themes::open_new(const QString newfile) {
	m_configfile = newfile;
	load();
}

void themes::save_as(const QString newfile) {
	m_configfile = newfile;
	save();
}

void themes::load() {
	loaddb(m_configfile);

	widget_main->style_current->setText(m_configfile);
	load_misc();
	load_menu();
	load_window();
	load_toolbar();

	setIsModified(false);
}

bool themes::save() {
	QString s= strrchr(m_configfile, '/') +1;
	s.append(" for blackbox.");

	saveResourceComment(s);
	saveResourceComment("Automagically generated by bbconf.\n\n");

	saveResourceComment("Miscellaneous settings...");
	save_misc();
	saveResourceBlank();

	saveResourceComment("Toolbar settings...");
	save_toolbar();
	saveResourceBlank();

	saveResourceComment("Menu settings...");
	save_menu();
	saveResourceBlank();

	saveResourceComment("Window settings...");
	save_window();
	saveResourceBlank();

	setIsModified(false);
	bool saved = savedb(m_configfile);
	bool restarted = false;

	if (saved) {
		widget_main->style_current->setText(m_configfile);

		// try to get _BLACKBOX_PID from our root window so we can
		// kill -HUP the pid. if we can't, resort to 
		// 'killall -HUP blackbox'
#ifdef Q_WS_X11
		Atom blackbox_pid = XInternAtom( QPaintDevice::x11AppDisplay(), "_BLACKBOX_PID", FALSE  );
		Atom type;
	
		int format;
		unsigned long length, after;
		unsigned char *data;
		XGetWindowProperty( QPaintDevice::x11AppDisplay(), 
			RootWindow(QPaintDevice::x11AppDisplay(),  QPaintDevice::x11AppScreen()),
			blackbox_pid, 
			0L, 1L, FALSE, AnyPropertyType, &type, &format,
			&length, &after, &data );
	
		if ((type == XA_CARDINAL) && (format == 32) && data) {
			pid_t pid = *((unsigned long *) data);
			restarted = true;

			QString cmd;
			cmd.sprintf("kill -HUP %d", pid);
			qWarning("bbconf: doing: cmd->%s<-", cmd.latin1());
			system(cmd);

			XFree(data);
		} 
#else
		// FIXME(E): Implement for Qt Embedded
#endif

		if (!restarted) {
			// tell blackbox to reconfigure with the settings we just saved
			qWarning("bbconf: doing: cmd->killall -HUP blackbox<-");
			system("killall -HUP blackbox");
		}
	}
	return saved;
}

/* menu */

void themes::load_menu() {

	QString *s = new QString("");
	int i=0;
	
	load_widget("menu.frame", "Menu.Frame", widget_menu->menu_frame);
	load_widget("menu.title", "Menu.Title", widget_menu->menu_title);
	load_widget("menu.hilite", "Menu.Hilite", widget_menu->menu_hilite);

	s = loadResource("menu.bullet", "Menu.Bullet", "");
	if (s->contains("empty",false)) i = EMPTY;
	else if (s->contains("square",false)) i = SQUARE;
	else if (s->contains("triangle",false)) i = TRIANGLE;
	else if (s->contains("diamond",false)) i = DIAMOND;
	widget_menu->menu_bullet_style->setCurrentItem(i); delete s;

	s = loadResource("menu.bullet.position", "Menu.Bullet.Position", "");
	if (s->contains("right",false)) i = RIGHT;
	else if (s->contains("left",false)) i = LEFT;
	widget_menu->menu_bullet_position->setCurrentItem(i); delete s;

	s = loadResource( "menu.frame.disableColor", "Menu.Frame.DisableColor", "#ffffff");
	widget_menu->menu_frame_disablecolor->setColor(*s); delete s;
}

void themes::save_menu() {

	save_widget("menu.frame", widget_menu->menu_frame);
	save_widget("menu.title", widget_menu->menu_title);
	save_widget("menu.hilite", widget_menu->menu_hilite);

	saveResource("menu.bullet", 
		(const char*)widget_menu->menu_bullet_style->currentText() );
	saveResource("menu.bullet.position", 
		(const char*)widget_menu->menu_bullet_position->currentText() );
	saveResource("menu.frame.disableColor", 
		(const char*)widget_menu->menu_frame_disablecolor->getColorString().prepend("#") );
}

/* window */

void themes::load_window() {

	QString *s=0;
	int i=0;
	
	// our panels
	load_widget("window.button.focus", "Window.Button.Focus", widget_window->win_button_focus);
	load_widget("window.button.unfocus", "Window.Button.Unfocus", widget_window->win_button_unfocus);

	load_widget("window.grip.focus", "Window.Grip.Focus", widget_window->win_grip_focus);
	load_widget("window.grip.unfocus", "Window.Grip.Unfocus", widget_window->win_grip_unfocus);

	load_widget("window.handle.focus", "Window.Handle.Focus", widget_window->win_handle_focus);
	load_widget("window.handle.unfocus", "Window.Handle.Unfocus", widget_window->win_handle_unfocus);
	
	// grr this one's weird.  window.font and window.justify hold the values
	// we need, so we have to make 2 calls *grrrr*
	load_widget("window.label.focus", "Window.Label.Focus", widget_window->win_label_focus);
	s = loadResource( "window.font", "Window.Font", "nexus");
	widget_window->win_label_focus->setFont(*s); delete s;
	s = loadResource( "window.justify", "Window.Justify", "right");
	if (s->contains("left",false)) i=LEFTJUSTIFY;
	else if (s->contains("right",false)) i=RIGHTJUSTIFY;
	else i=CENTERJUSTIFY;
	widget_window->win_label_focus->setJustify(i); delete s;

	load_widget("window.label.unfocus", "Window.Label.Unfocus", widget_window->win_label_unfocus);

	load_widget("window.title.focus", "Window.Title.Focus", widget_window->win_title_focus);
	load_widget("window.title.unfocus", "Window.Title.Unfocus", widget_window->win_title_unfocus);

	// leftover widgets
	load_widget("window.button.pressed", "Window.Button.Pressed", widget_window->win_button_pressed);

	s = loadResource("window.frame.focusColor", "Window.Frame.FocusColor", "#ffffff");
	widget_window->win_frame_focused_color->setColor(*s); delete s;
	s = loadResource("window.frame.unfocusColor", "Window.Frame.UnfocusColor", "#ffffff");
	widget_window->win_frame_unfocused_color->setColor(*s); delete s;

	s = loadResource( "handleWidth", "HandleWidth", "0");
	widget_window->handle_width->setValue(atoi(*s)); delete s;
	s = loadResource( "frameWidth", "FrameWidth", "0");
	widget_window->frame_width->setValue(atoi(*s)); delete s;
	s = loadResource( "bevelWidth", "BevelWidth", "0");
	widget_window->bevel_width->setValue(atoi(*s)); delete s;
	s = loadResource( "borderWidth", "BorderWidth", "0");
	widget_window->border_width->setValue(atoi(*s)); delete s;

	s = loadResource( "borderColor", "BorderColor", "#ffffff");
	widget_window->border_color->setColor(*s); delete s;
}

void themes::save_window() {

	save_widget("window.button.focus", widget_window->win_button_focus);
	save_widget("window.button.unfocus", widget_window->win_button_unfocus);

	save_widget("window.grip.focus", widget_window->win_grip_focus);
	save_widget("window.grip.unfocus", widget_window->win_grip_unfocus);

	save_widget("window.handle.focus", widget_window->win_handle_focus);
	save_widget("window.handle.unfocus", widget_window->win_handle_unfocus);

	// grr this one's weird.  window.font and window.justify hold the values
	// we need, so we have to make 2 calls *grrrr*
	save_widget("window.label.focus", widget_window->win_label_focus);
	saveResource("window.font", 
		(const char*)widget_window->win_label_focus->getFont());
	saveResource("window.justify", 
		(const char*)widget_window->win_label_focus->getJustify());

	save_widget("window.label.unfocus", widget_window->win_label_unfocus);

	save_widget("window.title.focus", widget_window->win_title_focus);
	save_widget("window.title.unfocus", widget_window->win_title_unfocus);

	// leftover widgets
	save_widget("window.button.pressed", widget_window->win_button_pressed);
	saveResource("window.frame.focusColor", 
		(const char*)widget_window->win_frame_focused_color->getColorString().prepend("#"));
	saveResource("window.frame.unfocusColor", 
		(const char*)widget_window->win_frame_unfocused_color->getColorString().prepend("#"));

	saveResource("handleWidth", 
		(const char*)widget_window->handle_width->text() );
	saveResource("frameWidth", 
		(const char*)widget_window->frame_width->text() );
	saveResource("bevelWidth", 
		(const char*)widget_window->bevel_width->text() );
	saveResource("borderWidth", 
		(const char*)widget_window->border_width->text() );

	saveResource("borderColor", 
		(const char*)widget_window->border_color->getColorString().prepend("#") );

}

/* toolbar */

void themes::load_toolbar() {

	load_widget("toolbar.button", "Toolbar.Button", widget_toolbar->tb_button_unpressed);
	load_widget("toolbar.button.pressed", "Toolbar.Button.Pressed", widget_toolbar->tb_button_pressed);

	load_widget("toolbar.label", "Toolbar.Label", widget_toolbar->tb_toolbar_label);
	load_widget("toolbar.windowLabel", "toolbar.Windowlabel", widget_toolbar->tb_window_label);

	load_widget("toolbar.clock", "Toolbar.Clock", widget_toolbar->tb_clock);
	load_widget("toolbar", "Toolbar", widget_toolbar->tb_toolbar);

}

void themes::save_toolbar() {

	save_widget("toolbar.button", widget_toolbar->tb_button_unpressed);
	save_widget("toolbar.button.pressed", widget_toolbar->tb_button_pressed);

	save_widget("toolbar.label", widget_toolbar->tb_toolbar_label);
	save_widget("toolbar.windowLabel", widget_toolbar->tb_window_label);

	save_widget("toolbar.clock", widget_toolbar->tb_clock);
	save_widget("toolbar", widget_toolbar->tb_toolbar);

}

/* misc */

void themes::load_misc() {
	QString *s;

	s = loadResource("style.name", "Style.Name", "Untitled");
	widget_misc->TStyleName->setText(*s); delete s;
	s = loadResource("style.author", "Style.Author", "Unnamed");
	widget_misc->TStyleAuthor->setText(*s); delete s;
	s = loadResource("style.date", "Style.Date", QDate::currentDate().toString());
	widget_misc->TStyleDate->setText(*s); delete s;
	s = loadResource("style.credits", "Style.Credits", "");
	widget_misc->TStyleCredits->setText(*s); delete s;
	s = loadResource("style.comments", "Style.Comments", "");
	*s = s->simplifyWhiteSpace();
	widget_misc->TComments->setText(*s); delete s;
	s = loadResource("rootCommand", "RootCommand", "");
	widget_misc->TRootCommand->setText(*s); delete s;

}

void themes::save_misc() {

	saveResource("style.name", (const char*)widget_misc->TStyleName->text());
	saveResource("style.author", (const char*)widget_misc->TStyleAuthor->text());
	saveResource("style.date", (const char*)widget_misc->TStyleDate->text());
	saveResource("style.credits", (const char*)widget_misc->TStyleCredits->text());

	int lines = widget_misc->TComments->numLines();
	QString s;

	for(int i=0; i <= lines; i++) {
		s.append("\t\t");
		s.append( widget_misc->TComments->textLine(i) );
		if (i < lines - 1 )
			s.append("\\");
		s.append("\n");
	}
	saveResource("style.comments", (const char*)s);

	saveResource("rootCommand", (const char*)widget_misc->TRootCommand->text());

}

// ---------------------------------------------------------------- //
// --  start of base-level widget loaders                        -- //
// ---------------------------------------------------------------- //

void themes::load_widget(QString s1, QString s2, TWBasic* ptr) {
	
	QString w1,w2;
	QString *s=0;

	w1 = s1; w2 = s2;
	s = loadResource(w1, w2, "");
	ptr->setFullTexture(*s); delete s;
	s = loadResource( w1+".color", w2+".Color", "#ffffff");
	ptr->setColor(*s); delete s;
	s = loadResource( w1+".colorTo", w2+".ColorTo", "#ffffff");
	ptr->setColorTo(*s); delete s;
}

void themes::load_widget(QString s1, QString s2, TWPicColor* ptr) {
	
	QString w1,w2;
	QString *s=0;

	w1 = s1; w2 = s2;
	s = loadResource(w1, w2, "");
	ptr->setFullTexture(*s); delete s;
	s = loadResource( w1+".color", w2+".Color", "#ffffff");
	ptr->setColor(*s); delete s;
	s = loadResource( w1+".colorTo", w2+".ColorTo", "#ffffff");
	ptr->setColorTo(*s); delete s;
	s = loadResource( w1+".picColor", w2+".PicColor", "#ffffff");
	ptr->setPicColor(*s); delete s;
}

void themes::load_widget(QString s1, QString s2, TWText* ptr) {
	
	QString w1,w2;
	QString *s=0;

	w1 = s1; w2 = s2;
	s = loadResource(w1, w2, "");
	ptr->setFullTexture(*s); delete s;
	s = loadResource( w1+".color", w2+".Color", "#ffffff");
	ptr->setColor(*s); delete s;
	s = loadResource( w1+".colorTo", w2+".ColorTo", "#ffffff");
	ptr->setColorTo(*s); delete s;
	s = loadResource( w1+".textColor", w2+".TextColor", "#ffffff");
	ptr->setTextColor(*s); delete s;
}


void themes::load_widget(QString s1, QString s2, TWTextSelect* ptr) {
	
	QString w1,w2;
	QString *s=0;
	int i=0;

	w1 = s1; w2 = s2;
	s = loadResource(w1, w2, "");
	ptr->setFullTexture(*s); delete s;
	s = loadResource( w1+".color", w2+".Color", "#ffffff");
	ptr->setColor(*s); delete s;
	s = loadResource( w1+".colorTo", w2+".ColorTo", "#ffffff");
	ptr->setColorTo(*s); delete s;
	s = loadResource( w1+".textColor", w2+".TextColor", "#ffffff");
	ptr->setTextColor(*s); delete s;
	s = loadResource( w1+".font", w2+".Font", "nexus");
	ptr->setFont(*s); delete s;
	s = loadResource( w1+".justify", w2+".Justify", "right");
	if (s->contains("left",false)) i=LEFTJUSTIFY;
	else if (s->contains("right",false)) i=RIGHTJUSTIFY;
	else i=CENTERJUSTIFY;
	ptr->setJustify(i); delete s;
}

// ---------------------------------------------------------------- //
// --  end of base-level widget loaders                          -- //
// ---------------------------------------------------------------- //

void themes::save_widget(QString s, TWBasic* ptr) {
	saveResource(s, (const char*)ptr->getFullTexture() );
	saveResource(s+".color", (const char*)ptr->getColorString().prepend("#") );
	if (ptr->color_to->isEnabled() ) 
		saveResource(s+".colorTo", (const char*)ptr->getColorToString().prepend("#") );
	saveResourceBlank();
}

void themes::save_widget(QString s, TWPicColor* ptr) {
	saveResource(s, (const char*)ptr->getFullTexture() );
	saveResource(s+".color", (const char*)ptr->getColorString().prepend("#") );
	if (ptr->color_to->isEnabled() ) 
		saveResource(s+".colorTo", (const char*)ptr->getColorToString().prepend("#") );
	saveResource(s+".picColor", (const char*)ptr->getPicColorString().prepend("#") );
	saveResourceBlank();
}

void themes::save_widget(QString s, TWText* ptr) {
	saveResource(s, (const char*)ptr->getFullTexture() );
	saveResource(s+".color", (const char*)ptr->getColorString().prepend("#") );
	if (ptr->color_to->isEnabled() ) 
		saveResource(s+".colorTo", (const char*)ptr->getColorToString().prepend("#") );
	saveResource(s+".textColor", (const char*)ptr->getTextColorString().prepend("#") );
	saveResourceBlank();
}

void themes::save_widget(QString s, TWTextSelect* ptr) {
	saveResource(s, (const char*)ptr->getFullTexture() );
	saveResource(s+".color", (const char*)ptr->getColorString().prepend("#") );
	if (ptr->color_to->isEnabled() ) 
		saveResource(s+".colorTo", (const char*)ptr->getColorToString().prepend("#") );
	saveResource(s+".textColor", (const char*)ptr->getTextColorString().prepend("#") );
	saveResource(s+".font", (const char*)ptr->getFont() );
	saveResource(s+".justify", (const char*)ptr->getJustify() );
	saveResourceBlank();
}

