#!/usr/bin/perl

sub usage {
print <<EOWIBBLE;

# $0 

# Simple perl script to attach a given header file onto the top of every
# source and header file in the tree. Useful for mass-updating header
# information or getting it started for the first time...  =:)

# AUTHOR: Jason Kasper (vanRijn) <vR\@movingparts.net>

# LICENSE: Umm.  I'm not a lawyer and most probably neither are you.  So
# let's keep this simple.  I like to code.  I give you permission to use my
# code. I give you permission to change my code.  I give you permission to 
# distribute my code.  I give you permission to sneeze on my code (if you
# wipe it off quickly thereafter). If you'd like to make a change, have at it.
# Please give me credit for my code, and don't distribute my code with your
# changes unless you give me credit and indicate that you've made changes
# to my code, AND let me know what you've changed so that I can take
# advantage of you smart guys out there and add your improvements to my
# code base.  That's about it, I believe.

EOWIBBLE
}

$args=join('',@ARGV);
if ( $args=~/-h|-help|--h|--help/i) {
	usage();
	exit;
}

use Cwd;
use File::Find ();
use File::Basename; 

use Time::localtime;
$tm = localtime;
($DAY, $MONTH, $YEAR) = ($tm->mday, $tm->mon, $tm->year+1900);

$headerfile="bbconf/templates/header_template";
open (HEAD, "<$headerfile") or die "Can't open header file\n";
$header=join('',<HEAD>);
close (HEAD);

$begindir=cwd();

@sourcedirs=("bbconf", 
	"bbconf/plugins/menu", 
	"bbconf/plugins/themes",
	"bbconf/plugins/keybindings", 
	"bbconf/plugins/bbconf");

foreach $dir (@sourcedirs) {
	chdir "$dir" or die "Can't cd to ->$dir<- $!\n";

	@files = glob("*.h *.cc");

	foreach $file (@files) {
		print "\nNow serving infile ->$file<-\n";
		open (IN, "< $file")
			or die "Can't open infile ->$file<-. Exit.\n";
		$IN=join('',<IN>);
		close (IN);
	
		$myheader=$header;
		$myheader=~s/FILENAME/$file/sig;
		$myheader=~s/ENDYEAR/$YEAR/sig;

		$OUT = $IN;

		if ($IN =~/E_O_H_VR/sig) {
			print ("Previously applied this file. Overlaying header.\n");
			$OUT=~s/.*E_O_H_VR\n/$myheader/sig;
		} else {
			print ("Previous header not found. Inserting header.\n");
			$OUT = $myheader . $IN;
		}

		open (OUT, "> $file")
			or die "Can't open outfile ->$file<-. Exit.\n";
		print OUT $OUT;
		close (OUT);

	}

	# go back to where we started from
	chdir "$begindir" or die "Can't cd to ->$begindir<- $!\n";
}

exit;
