/* beef - load.c
    Copyright (C) 2005-2006  KiyuKo
    This file is part of beef 0.0.5

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License as
     published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     For any comment about this program, or eventually for bug report,
     feel free to mail <eof AT kiyuko DOT org>
     The program page is on http://www.kiyuko.org/beef */

#include "beef.h"

struct instruction *load (FILE *fp, char debug)
{
  struct instruction *first;
  struct instruction *current;
  char c, d;
  long i;

  /* Create a new instruction */
  current = (struct instruction *) malloc (sizeof (struct instruction));
  first = current;
  
  /* Stop when end of file is reached */
  do {
    /* Read a char from the input stream */
    c = fgetc (fp);
    /* Reset the quantity counter */
    i = 0;
    
    switch (c) {
      case '[':
        current->type = c;
        current->quantity = 1;
        /* Read the loop calling this same function */
        current->loop = load (fp, debug);
        break;

      case ']':
        current->type = c;
        current->quantity = 1;
        /* We're finished reading the loop, return the code */
        return first;
        break;

      case '<': case '>':
      case '+': case '-':
      case '.': case ',':
      case '#':
        /* Ignore any # if debug is turned off */
        if (((c == '#') && (debug == ON)) || (c != '#')) {
          current->type = c;
          if (!feof (fp)) {
            /* Stop at end of file, or at the firts different char */
            do {
              /* Increase the counter */
              i++;
              /* Read another char */
              d = fgetc (fp);
            } while ((!feof (fp)) && (c == d));
            /* Return the last char to the input stream */
            ungetc (d, fp);
            current->quantity = i;
          }
        }
        break;

      default:
        /* Ignore any other char */
        break;
    }
    
    /* Instruction stored correctly: create a new one */
    if (current->quantity != 0) {
      current->next =(struct instruction *) malloc (sizeof(struct instruction));
      current = current->next;
    }
  } while (!feof (fp));
  
  /* This is the closing instruction */
  current->type = ']';
  return first;
}

