/* beef - main.c
    Copyright (C) 2005-2006  KiyuKo
    This file is part of beef 0.0.5

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License as
     published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     For any comment about this program, or eventually for bug report,
     feel free to mail <eof AT kiyuko DOT org>
     The program page is on http://www.kiyuko.org/beef */

#include "beef.h"

int main (int argc, char **argv)
{
  /* Input file */
  FILE *fp;
  /* Program code */
  struct instruction *code;
  /* Behaviour on EOF  */
  char on_eof = STORE_ZERO;
  /* Debug on/off (default is off)  */
  char debug = OFF;
  int count;
  int num;

  /* Number of real args (ignore program name) */
  count = argc - 1;
  /* There are no args */
  if (count < 1) {
    /* Print a short usage message and exit with error */
    printf ("Usage: %s [OPTIONS] file\n", PROGRAM_NAME);
    return -1;
  }
  else {
    if (!strcmp (argv[count], "--help")) {
      /* Show an help message and exit with success */
      printf ("\
Usage: %s [OPTIONS] file\n\
\n\
Options:\n\
  -e		Store an EOF in the current cell when reads an EOF from input\n\
  -n		Does nothing when reads an EOF from input\n\
  -d		Enable the debugging command `#' (which dumps the tape)\n\
  --version	Shows version number and exits successfully\n\
  --help	Shows this help and exits succesfully\n\
\n", PROGRAM_NAME);
      return 0;
    }
    if (!strcmp (argv[1], "--version")) {
      /* Print a version number and exit with success */
      printf ("\
%s version %s\n\
Copyright (C) 2005-2006 KiyuKo (http://www.kiyuko.org)\n", PROGRAM_NAME, VERSION);
      return 0;
    }

    /* Read command line args */
    for (num = 1; num < count; num++) {
      if (!strcmp (argv[num], "-e"))
        on_eof = STORE_EOF;
      if (!strcmp (argv[num], "-n"))
        on_eof = DO_NOTHING;
      if (!strcmp (argv[num], "-d"))
        debug = ON;
    }

    /* Try to open the input file */
    fp = fopen (argv[count], "r");
    if (fp == NULL) {
      /* Print an error message and exit */
      fprintf (stderr, "%s: Cannot open input file\n", PROGRAM_NAME);
      return -1;
    }
    /* Everything is ok */
    else {
      /* Create first cell */
      tape = new_cell ();

      /* Load program code */
      code = load (fp, debug);
      fclose (fp);

      /* Dumps the code tree on screen. This is useful for debug only */
      /* code_dump (code, 0); */
      
      /* Start executing the code */
      eval (code, on_eof);
    }
  }
  /* Exit with success */
  return 0;
}

