/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2002  Peter Alm, Mikael Alm, Olle Hallnas,
 *                           Thomas Nilsson and 4Front Technologies
 *  Copyright (C) 1999-2002  Haavard Kvaalen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef MAIN_H
#define MAIN_H

#include "mainwin.h"
#include "textbox.h"
#include "vis.h"

#define PLAYER_HEIGHT ((cfg.player_shaded ? 14 : 116) * (cfg.doublesize + 1))
#define PLAYER_WIDTH   (275 * (cfg.doublesize + 1))

typedef struct {
    gint player_x, player_y, equalizer_x, equalizer_y;
    gint playlist_x, playlist_y, playlist_width, playlist_height;
    guint snap_distance;
    gboolean use_realtime, shuffle, repeat, doublesize, autoscroll;
    gboolean analyzer_peaks, equalizer_autoload, easy_move,
	equalizer_active;
    gboolean playlist_visible, equalizer_visible, player_visible;
    gboolean player_shaded, playlist_shaded, equalizer_shaded;
    gboolean allow_multiple_instances, always_show_cb;
    gboolean convert_underscore, convert_twenty;
    gboolean show_numbers_in_pl, snap_windows, save_window_position;
    gboolean dim_titlebar, get_info_on_load;
    gboolean get_info_on_demand, eq_doublesize_linked;
    gboolean sort_jump_to_file, use_eplugins, always_on_top, sticky;
    gboolean no_playlist_advance, smooth_title_scroll, use_pl_metadata;
    gboolean warn_about_unplayables;
    gboolean use_backslash_as_dir_delimiter;
    gboolean random_skin_on_play, use_fontsets;
    gboolean mainwin_use_xfont;
    gfloat equalizer_preamp, equalizer_bands[10];
    gchar *skin, *outputplugin, *filesel_path, *playlist_path;
    gchar *playlist_font, *mainwin_font;
    gchar *disabled_iplugins, *enabled_gplugins, *enabled_vplugins,
	*enabled_eplugins;
    gchar *eqpreset_default_file, *eqpreset_extension;
    GList *url_history;
    gint timer_mode, vis_type, analyzer_mode, analyzer_type, scope_mode;
    gint vu_mode, vis_refresh;
    gint analyzer_falloff, peaks_falloff;
    gint playlist_position;
    gint pause_between_songs_time;
    gboolean pause_between_songs, show_wm_decorations;
    gint mouse_change;
    gboolean playlist_transparent;
    gchar *gentitle_format;
    gboolean softvolume_enable;
    gboolean xmms_compat_mode;
} Config;

extern Config cfg;

extern GList *disabled_iplugins;
extern GList *dock_window_list;
extern gboolean pposition_broken;

void save_config(void);

enum {
    VOLSET_STARTUP, VOLSET_UPDATE, VOLUME_ADJUSTED, VOLUME_SET
};

#endif
