/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

#define ERR_NO_ERROR		0
#define ERR_INVALID_CATEGORY     -1
#define ERR_INVALID_TEST            -2
#define ERR_TEST_CODE_FAILED     -3
#define ERR_INVALID_CMD_LINE      -4

#define ERR_INCORRECT_RETURN_VALUE     -1000
#define ERR_TEST_FAILED                        -1001

CK_SLOT_ID slotID;

int c_Digest (void)
{
   int iNrErrors = 0;

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++iNrErrors;
	}

	slotID = getFirstSlot(1);

   printf ("C_Digest\n");
   printf ("Cat 1\n");
//   printf ("Test 1 : ");
   if (C_DigestTests (1, 1) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 2 : ");
   if (C_DigestTests (1, 2) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 3 : ");
   if (C_DigestTests (1, 3) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 4 : ");
   if (C_DigestTests (1, 4) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 5 : ");
   if (C_DigestTests (1, 5) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }


   printf ("Cat 2\n");
//   printf ("Test 1 : ");
   if (C_DigestTests (2, 1) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 2 : ");
   if (C_DigestTests (2, 2) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 3 : ");
   if (C_DigestTests (2, 3) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 4 : ");
   if (C_DigestTests (2, 4) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

   return (iNrErrors);
}

int C_DigestTests (int iCategory, int iTest)
{
   int iReturnVal = ERR_NO_ERROR;

   switch (iCategory)
   {
      case 1:
         iReturnVal = C_DigestCategory1 (iTest);
      break;

      case 2:
         iReturnVal = C_DigestCategory2 (iTest);
      break;
      default:
         iReturnVal = ERR_INVALID_CATEGORY;
      break;
   }
   return (iReturnVal);
}

int C_DigestCategory1 (int iTest)
{
   int iReturnVal = ERR_NO_ERROR;

   switch (iTest)
   {
      case 1:
         iReturnVal = C_DigestCategory1Test1 ();
      break;
      case 2:
         iReturnVal = C_DigestCategory1Test2 ();
      break;
      case 3:
         iReturnVal = C_DigestCategory1Test3 ();
      break;
      case 4:
         iReturnVal = C_DigestCategory1Test4 ();
      break;
      case 5:
         iReturnVal = C_DigestCategory1Test5 ();
      break;
      default:
         iReturnVal = ERR_INVALID_TEST;
      break;
   }
   return (iReturnVal);
}

int C_DigestCategory2 (int iTest)
{
   int iReturnVal = ERR_NO_ERROR;

   switch (iTest)
   {
      case 1:
         iReturnVal = C_DigestCategory2Test1 ();
      break;
      case 2:
         iReturnVal = C_DigestCategory2Test2 ();
      break;
      case 3:
         iReturnVal = C_DigestCategory2Test3 ();
      break;
      case 4:
         iReturnVal = C_DigestCategory2Test4 ();
      break;
      default:
         iReturnVal = ERR_INVALID_TEST;
      break;
   }
   return (iReturnVal);
}

int C_DigestCategory1Test1 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_RV rv = CKR_OK;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;

   rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
   if (CKR_OK == rv)
      iReturnVal = ERR_TEST_FAILED;
   if (CKR_SESSION_HANDLE_INVALID != rv)
      iReturnVal = ERR_TEST_FAILED;

   return (iReturnVal);
}

int C_DigestCategory1Test2 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;

   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit(hSession, &mechanism))
      {
         if (CKR_OK != p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen))
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory1Test3 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;
   CK_RV rv = CKR_OK;

   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
      if (CKR_OK != rv)
      {
         if (CKR_OPERATION_NOT_INITIALIZED != rv)
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory1Test4 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;
   CK_RV rv = CKR_OK;

   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_CloseSession (hSession))
      {
         rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
         if (CKR_OK != rv)
         {
            if (CKR_SESSION_HANDLE_INVALID != rv)
               iReturnVal = ERR_TEST_FAILED;
         }
         else
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory1Test5 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;
   CK_RV rv = CKR_OK;

   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
	if (p11->C_DigestInit(hSession, &mechanism) != CKR_OK)
		return ERR_TEST_FAILED;

      rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
      if (CKR_OK == rv)
      {
         rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
         if (CKR_OK != rv)
         {
            if (CKR_OPERATION_NOT_INITIALIZED != rv)
               iReturnVal = ERR_TEST_FAILED;
         }
         else
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory2Test1 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 0;

   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit(hSession, &mechanism))
      {
         if (CKR_OK == p11->C_Digest (hSession, ucRawData, dwRawDataLen, NULL_PTR, &dwHashDataLen))
         {
            if (16 != dwHashDataLen)
               iReturnVal = ERR_TEST_FAILED;
         }
         else
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory2Test2 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 0;
   CK_RV rv = ERR_NO_ERROR;

   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit(hSession, &mechanism))
      {
         dwHashDataLen = 15;
         rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
         if (CKR_OK != rv)
         {
            if (16 != dwHashDataLen)
               iReturnVal = ERR_TEST_FAILED;
            if (CKR_BUFFER_TOO_SMALL != rv)
               iReturnVal = ERR_TEST_FAILED;
         }
         else
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory2Test3 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   int k, i, iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[20];
   CK_ULONG dwHashDataLen = 0;
   CK_RV rv = ERR_NO_ERROR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};

   CK_ULONG dwHashLen = 16;

   for (k = 0; k < 256; k++)
      ucRawData [k] = (CK_BYTE)k;

   // Open a session with PKCS#11
   if (CKR_OK == p11->C_OpenSession(slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      // Initialise the digesting operation with a mechanism
      if (CKR_OK == p11->C_DigestInit(hSession, &mechanism))
      {
         // Reset the resulting data
         memset (ucHashData, 0, 20);
         // p11->C_DigestUpdate to enter some data
         rv = p11->C_DigestUpdate (hSession, ucRawData, dwRawDataLen);
         if (CKR_OK != rv)
            iReturnVal = ERR_TEST_CODE_FAILED;
         rv = p11->C_DigestUpdate (hSession, ucRawData, dwRawDataLen);
         if (CKR_OK != rv)
            iReturnVal = ERR_TEST_CODE_FAILED;
   
         // Hash the raw data, this call is not allowed
         rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
         if (CKR_OK == rv)
               iReturnVal = ERR_TEST_FAILED;
      }
      // Error initialising hashing operations
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   // Errors opening a session with PKCS#11
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestCategory2Test4 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_RV rv = CKR_OK;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++iReturnVal;
	}

   rv = p11->C_Digest (hSession, ucRawData, dwRawDataLen, ucHashData, &dwHashDataLen);
   if (CKR_OK == rv)
      iReturnVal = ERR_TEST_FAILED;
   if (CKR_CRYPTOKI_NOT_INITIALIZED != rv)
      iReturnVal = ERR_TEST_FAILED;

   return (iReturnVal);
}
