/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

#define ERR_NO_ERROR		0
#define ERR_INVALID_CATEGORY     -1
#define ERR_INVALID_TEST            -2
#define ERR_TEST_CODE_FAILED     -3
#define ERR_INVALID_CMD_LINE      -4

#define ERR_INCORRECT_RETURN_VALUE     -1000
#define ERR_TEST_FAILED                        -1001

CK_SLOT_ID slotID;

int c_DigestUpdateFinal (void)
{
   int iNrErrors = 0;

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++iNrErrors;
	}

	slotID = getFirstSlot(1);

   printf ("C_DigestUpdate and C_DigestUpdateFinal\n");
   printf ("Cat 1\n");
//   printf ("Test 1 : ");
   if (C_DigestUpdateTests (1, 1) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 2 : ");
   if (C_DigestUpdateTests (1, 2) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 3 : ");
   if (C_DigestUpdateTests (1, 3) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }


   printf ("Cat 2\n");
//   printf ("Test 1 : ");
   if (C_DigestUpdateTests (2, 1) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 2 : ");
   if (C_DigestUpdateTests (2, 2) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

//   printf ("Test 3 : ");
   if (C_DigestUpdateTests (2, 3) == 0)
;
//      printf ("OK\n");
   else
   {
      printf ("Failed\n");
      iNrErrors++;
   }

   return (iNrErrors);
}



int C_DigestUpdateTests (int iCategory, int iTest)
{
   int iReturnVal = ERR_NO_ERROR;

   switch (iCategory)
   {
      case 1:
         iReturnVal = C_DigestUpdateCategory1 (iTest);
      break;

      case 2:
         iReturnVal = C_DigestUpdateCategory2 (iTest);
      break;
      default:
         iReturnVal = ERR_INVALID_CATEGORY;
      break;
   }
   return (iReturnVal);
}

int C_DigestUpdateCategory1 (int iTest)
{
   int iReturnVal = ERR_NO_ERROR;

   switch (iTest)
   {
      case 1:
         iReturnVal = C_DigestUpdateCategory1Test1 ();
      break;
      case 2:
         iReturnVal = C_DigestUpdateCategory1Test2 ();
      break;
      case 3:
         iReturnVal = C_DigestUpdateCategory1Test3 ();
      break;
      default:
         iReturnVal = ERR_INVALID_TEST;
      break;
   }
   return (iReturnVal);
}

int C_DigestUpdateCategory2 (int iTest)
{
   int iReturnVal = ERR_NO_ERROR;

   switch (iTest)
   {
      case 1:
         iReturnVal = C_DigestUpdateCategory2Test1 ();
      break;

      case 2:
         iReturnVal = C_DigestUpdateCategory2Test2 ();
      break;
      case 3:
         iReturnVal = C_DigestUpdateCategory2Test3 ();
         break;
      default:
         iReturnVal = ERR_INVALID_TEST;
      break;
   }
   return (iReturnVal);
}

int C_DigestUpdateCategory1Test1 (void)
{
   CK_SESSION_HANDLE hSession=12345;
   CK_BYTE data[10];
   int iReturnVal = ERR_NO_ERROR;
   CK_RV rv = CKR_OK;

   rv = p11->C_DigestUpdate (hSession, data, 10);
   if (CKR_OK == rv)
      iReturnVal = ERR_TEST_FAILED;
   if (CKR_SESSION_HANDLE_INVALID != rv)
      iReturnVal = ERR_TEST_FAILED;

   return (iReturnVal);
}

int C_DigestUpdateCategory1Test2 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;

   if (CKR_OK == p11->C_OpenSession (slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit (hSession, &mechanism))
      {
         if (CKR_OK != p11->C_DigestUpdate (hSession, ucRawData, dwRawDataLen))
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}


int C_DigestUpdateCategory1Test3 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_RV rv = ERR_NO_ERROR;

   if (CKR_OK == p11->C_OpenSession (slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit (hSession, &mechanism))
      {
         if (CKR_OK == p11->C_CloseSession (hSession))
         {
            rv = p11->C_DigestUpdate (hSession, ucRawData, dwRawDataLen);
            // This test must fail
            if (CKR_OK == rv)
               iReturnVal = ERR_TEST_FAILED;
            else
            {
               if (CKR_SESSION_HANDLE_INVALID != rv)
                  iReturnVal = ERR_TEST_FAILED;
            }
         }
         else
            iReturnVal = ERR_TEST_CODE_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}

int C_DigestUpdateCategory2Test1 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int k, iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;
   CK_RV rv = ERR_NO_ERROR;
   CK_BYTE ucCorrectHashValues[16] = {0xF5,0xC8,0xE3,0xC3,0x1C,0x04,0x4B,0xAE,0x0E,0x65,0x56,0x95,0x60,0xB5,0x43,0x32};

   for (k = 0; k < 256; k++)
      ucRawData [k] = (CK_BYTE)k;

   if (CKR_OK == p11->C_OpenSession (slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit (hSession, &mechanism))
      {
         if (CKR_OK != p11->C_DigestUpdate (hSession, ucRawData, 128))
            iReturnVal = ERR_TEST_FAILED;
         if (CKR_OK != p11->C_DigestUpdate (hSession, &ucRawData[128], 128))
            iReturnVal = ERR_TEST_FAILED;
         // Set the length of the hash data too small
         dwHashDataLen = 15;
         rv = p11->C_DigestFinal (hSession, ucHashData, &dwHashDataLen);
         if (CKR_OK != rv)
         {
            if (CKR_BUFFER_TOO_SMALL != rv)
               iReturnVal = ERR_TEST_FAILED;
            if (16 != dwHashDataLen)
               iReturnVal = ERR_TEST_FAILED;
         }
         else
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}


int C_DigestUpdateCategory2Test2 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int k, iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_BYTE ucHashData[16];
   CK_ULONG dwHashDataLen = 16;
   CK_RV rv = ERR_NO_ERROR;
   CK_BYTE ucCorrectHashValues[16] = {0xF5,0xC8,0xE3,0xC3,0x1C,0x04,0x4B,0xAE,0x0E,0x65,0x56,0x95,0x60,0xB5,0x43,0x32};

   for (k = 0; k < 256; k++)
      ucRawData [k] = (CK_BYTE)k;

   if (CKR_OK == p11->C_OpenSession (slotID, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &hSession))
   {
      if (CKR_OK == p11->C_DigestInit (hSession, &mechanism))
      {
         if (CKR_OK != p11->C_DigestUpdate (hSession, ucRawData, 128))
            iReturnVal = ERR_TEST_FAILED;
         if (CKR_OK != p11->C_DigestUpdate (hSession, &ucRawData[128], 128))
            iReturnVal = ERR_TEST_FAILED;
         // Set the length of the hash data too small
         rv = p11->C_DigestFinal (hSession, NULL_PTR, &dwHashDataLen);
         if (CKR_OK == rv)
         {
            if (16 != dwHashDataLen)
               iReturnVal = ERR_TEST_FAILED;
         }
         else
            iReturnVal = ERR_TEST_FAILED;
      }
      else
         iReturnVal = ERR_TEST_CODE_FAILED;
   }
   else
      iReturnVal = ERR_TEST_CODE_FAILED;

   return (iReturnVal);
}


int C_DigestUpdateCategory2Test3 (void)
{
   CK_SESSION_HANDLE hSession=NULL_PTR;
   CK_MECHANISM mechanism = {CKM_MD5, NULL_PTR, 0};
   int iReturnVal = ERR_NO_ERROR;
   CK_BYTE ucRawData[256];
   CK_ULONG dwRawDataLen = 256;
   CK_RV rv = ERR_NO_ERROR;

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++iReturnVal;
	}

      rv = p11->C_DigestUpdate (hSession, ucRawData, dwRawDataLen);
      // This test must fail
      if (CKR_CRYPTOKI_NOT_INITIALIZED != rv)
            iReturnVal = ERR_TEST_FAILED;
 
   return (iReturnVal);
}
