/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_OpenSession()
{
	int errors = 0;
	CK_SLOT_ID slotID1;
	CK_SLOT_ID slotID2;
	CK_SESSION_HANDLE session;
	CK_FLAGS flags = CKF_SERIAL_SESSION;
	CK_SESSION_INFO info;

	printf("C_OpenSession\n");

	printf("Cat 1\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_OpenSession(12345, flags, NULL_PTR, NULL_PTR, &session) != CKR_SLOT_ID_INVALID) {
		printf("    ERR: C_OpenSession(1) didn't return CKR_SLOT_ID_INVALID\n");
		errors++;
	}

	slotID1 = getFirstSlot(1);

	if (p11->C_OpenSession(slotID1, flags, NULL_PTR, NULL_PTR, &session) != CKR_OK) {
		printf("    ERR: C_OpenSession(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_CloseSession(session) != CKR_OK) {
		printf("    ERR: C_CloseSession(2) didn't return CKR_OK\n");
		errors++;
	}

	slotID2 = getFirstSlot(0);

	if (p11->C_OpenSession(slotID2, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &session) != CKR_TOKEN_NOT_PRESENT) {
		printf("    ERR: C_OpenSession(1) didn't return CKR_TOKEN_NOT_PRESENT\n");
		errors++;
	}
	
	printf("Cat 2\n");

	if (p11->C_OpenSession(slotID1, CKF_RW_SESSION, NULL_PTR, NULL_PTR, &session) != CKR_SESSION_PARALLEL_NOT_SUPPORTED) {
		printf("    ERR: C_OpenSession(1) didn't return CKR_SESSION_PARALLEL_NOT_SUPPORTED\n");
		errors++;
	}

	flags = CKF_SERIAL_SESSION | CKF_RW_SESSION;
	if (p11->C_OpenSession(slotID1, flags, NULL_PTR, NULL_PTR, &session) != CKR_OK) {
		printf("    ERR: C_OpenSession(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_GetSessionInfo(session, &info) != CKR_OK) {
		printf("    ERR: C_GetSessionInfo(2) didn't return CKR_OK\n");
		errors++;
	}
	if (info.state != CKS_RW_PUBLIC_SESSION) {
		printf("    ERR: session state not equal to CKS_RW_PUBLIC_SESSION\n");
		errors++;
	}
	if (p11->C_CloseSession(session) != CKR_OK) {
		printf("    ERR: C_CloseSession(2) didn't return CKR_OK\n");
		errors++;
	}

	flags = CKF_SERIAL_SESSION;
	if (p11->C_OpenSession(slotID1, flags, NULL_PTR, NULL_PTR, &session) != CKR_OK) {
		printf("    ERR: C_OpenSession(3) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_GetSessionInfo(session, &info) != CKR_OK) {
		printf("    ERR: C_GetSessionInfo(3) didn't return CKR_OK\n");
		errors++;
	}
	if (info.state != CKS_RO_PUBLIC_SESSION) {
		printf("    ERR: session state not equal to CKS_RO_PUBLIC_SESSION\n");
		errors++;
	}
	if (p11->C_CloseSession(session) != CKR_OK) {
		printf("    ERR: C_CloseSession(3) didn't return CKR_OK\n");
		errors++;
	}

	flags = CKF_SERIAL_SESSION | 12345;
	if (p11->C_OpenSession(slotID1, flags, NULL_PTR, NULL_PTR, &session) != CKR_ARGUMENTS_BAD) {
		printf("    ERR: C_OpenSession(4) didn't return CKR_ARGUMENTS_BAD\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_OpenSession(slotID1, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &session) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_OpenSession() didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}

