// Config.h: interface for the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_)
#define AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _WIN32
    #pragma warning(disable:4786 4503)
#endif
#include <string>
#include <vector>
#include <map>

#include <wx/string.h>

#include "Base/platform.h"

class CConfig  
{
public:
	CConfig();
	virtual ~CConfig();
    
    static void Load();
    static void Unload();
    static const char *GetServerAddress();
    static const unsigned long GetServerPort();
    static const char *GetLogFile();
    static BOOL GetLogMode();
    static const char *GetHttpCRLStorePath();
    static const char *GetCRLStorePath();
    static BOOL GetCRLSchedule();
    static long GetLockTimeout();
    static char **GetAllowedIPAddress();
    static const char *GetProxyHost();
    static const char *GetProxyPort();

protected:
    static const char *CConfig::FindValue(char *pszSection, char *pszKey);

private:
    static char **SplitString(const char *psStr, int iLength, char cSep);
    static wxString GetGlobalDir();

// Members
private:
    static std::map<std::string, std::vector<std::pair<std::string, std::string> > > m_oMapConfig;
    typedef std::map<std::string, std::vector<std::pair<std::string, std::string> > >::iterator ConfigMapIT;
    typedef std::vector<std::pair<std::string, std::string> >::iterator ConfigVecIT;
};

#endif // !defined(AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_)
