// ServiceStarter.cpp: implementation of the ServiceStarter class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "ServiceStarter.h"
#include "wxmainapp.h"

#include <winsvc.h>
#include <stdio.h>

DECLARE_APP(MyApp)

// Define Service functions
void WINAPI ServiceMain(DWORD argc,LPTSTR argv[]);
void WINAPI ServiceControlHandler(DWORD fdwControl);
DWORD WINAPI ServiceControlHandlerHibernate(DWORD fdwControl, DWORD dwEventType, LPVOID lpEventData,  LPVOID lpContext);

// Define service table entry
static char gsServiceName[] = "Belgian Identity Card";

SERVICE_TABLE_ENTRY ServiceTable[] = {
            {gsServiceName, ServiceMain},
            {NULL, NULL } };
SERVICE_STATUS_HANDLE gServiceHandle = 0;
SERVICE_STATUS gServiceStatus = {0};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ServiceStarter::ServiceStarter()
{
}

ServiceStarter::~ServiceStarter()
{
}

void ServiceStarter::Run (void)
{
	// Start the NT service
	BOOL bStartStatus = StartServiceCtrlDispatcher (ServiceTable);

	if (bStartStatus == 0)
	{
		DWORD error = GetLastError ();
		char errorString[200] = {0};

		if (error == ERROR_INVALID_DATA)
		{
			sprintf (errorString, "The specified dispatch table contains entries that are not in the proper format");
		}
		else
		{
			sprintf (errorString, "Unknown error when starting service, error : %d", error);
		}
        ::MessageBox(NULL, errorString, "Service Error", MB_OK | MB_ICONERROR);
	}		
}

/////////////////////////////////////////////////////////////////////////

void WINAPI ServiceMain(DWORD argc, LPTSTR argv[])
{
    gServiceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
    gServiceStatus.dwCurrentState = SERVICE_STOPPED;
    if(wxGetApp().GetHibernate())
    {
        gServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN | SERVICE_ACCEPT_POWEREVENT;
    }
    else
    {
        gServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;
    }
    gServiceStatus.dwWin32ExitCode = 0;
    gServiceStatus.dwServiceSpecificExitCode = 0;
    gServiceStatus.dwCheckPoint = 0;
    gServiceStatus.dwWaitHint = 60000;

    if(wxGetApp().GetHibernate())
    {
        typedef SERVICE_STATUS_HANDLE (WINAPI *TRegisterServiceCtrlHandlerEx)(LPCSTR,LPHANDLER_FUNCTION_EX,LPVOID);
        TRegisterServiceCtrlHandlerEx pReg;
        wxDynamicLibrary winLoader("Advapi32");
        if(winLoader.IsLoaded())
        {
            pReg = (TRegisterServiceCtrlHandlerEx) ::GetProcAddress( winLoader.GetLibHandle(), "RegisterServiceCtrlHandlerExA");
            if(pReg != NULL)
            {
                gServiceHandle = pReg(gsServiceName, ServiceControlHandlerHibernate, NULL);
            }
            winLoader.Unload();
        }
    }
    else
    {
        gServiceHandle = RegisterServiceCtrlHandler(gsServiceName, ServiceControlHandler);
    }

	if (!gServiceHandle)
	{
        ::MessageBox(NULL, "Could not register service", "Service Error", MB_OK | MB_ICONERROR);
		return;
	}
	else
	{
		// Starting the service
        gServiceStatus.dwCurrentState = SERVICE_START_PENDING;
		SetServiceStatus (gServiceHandle, &gServiceStatus);	
	}
}

//////////////////////////////////////////////////////////////////////////

DWORD WINAPI ServiceControlHandlerHibernate(DWORD fdwControl, DWORD dwEventType, LPVOID lpEventData,  LPVOID lpContext)
{
    DWORD dwRet = NO_ERROR;
    switch (fdwControl)
    {
        case SERVICE_CONTROL_STOP:
        case SERVICE_CONTROL_SHUTDOWN:
			// Service stop pending
			gServiceStatus.dwCurrentState = SERVICE_STOP_PENDING;
			gServiceStatus.dwCheckPoint = 0;
			gServiceStatus.dwWaitHint = 60000;    // 60 sec.
			SetServiceStatus (gServiceHandle, &gServiceStatus);

            if(wxTheApp->GetTopWindow())
            {
                ::PostMessage((HWND)(wxTheApp->GetTopWindow()->GetHWND()), WM_CLOSE, 0, 0);
            }
            break;

        case SERVICE_CONTROL_INTERROGATE:
            break;

        case SERVICE_CONTROL_POWEREVENT:
            {
                CMasterManager *pMasterManager = CMasterManager::Instance();
                CLoggerManager *pLogManager = (CLoggerManager *)pMasterManager->GetManager("Logger");
                CCardChangeMonitor *pMonitor = wxGetApp().GetCardMonitor();
                if(PBT_APMQUERYSUSPEND == dwEventType)
                {
                    // Suspend CardMonitor
                    if(pMonitor != NULL)
                    {
                        if(pLogManager != NULL)
                        {
	                        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "Suspending ...");
                        }
                        pMonitor->Suspend();
                    }
                }
                else if(PBT_APMRESUMESUSPEND == dwEventType || PBT_APMQUERYSUSPENDFAILED == dwEventType)
                {
                    // Resume CardMonitor
                    if(pMonitor != NULL)
                    {
                        if(pLogManager != NULL)
                        {
	                        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "Resuming ...");
                        }
                        pMonitor->Resume();
                    }
                }
            }
            break;
        default:
            break;
    }
    return dwRet;
}

void WINAPI ServiceControlHandler(DWORD fdwControl)
{
    switch (fdwControl)
    {
        case SERVICE_CONTROL_STOP:
        case SERVICE_CONTROL_SHUTDOWN:
			// Service stop pending
			gServiceStatus.dwCurrentState = SERVICE_STOP_PENDING;
			gServiceStatus.dwCheckPoint = 0;
			gServiceStatus.dwWaitHint = 60000;    // 60 sec.
			SetServiceStatus (gServiceHandle, &gServiceStatus);

            if(wxTheApp->GetTopWindow())
            {
                ::PostMessage((HWND)(wxTheApp->GetTopWindow()->GetHWND()), WM_CLOSE, 0, 0);
            }
            break;

        case SERVICE_CONTROL_INTERROGATE:
            break;
        default:
            break;
    }
}

void ServiceStarter::ServiceSetStatus(DWORD dwStatus, DWORD dwCheckPoint)
{
/* 
    CMasterManager *pMasterManager = CMasterManager::Instance();
    CLoggerManager *pLogManager = (CLoggerManager *)pMasterManager->GetManager("Logger");

    if(pLogManager != NULL)
    {
        char szText[255] = {0};
        sprintf(szText, "Handle = %ld, ServiceStatus = %ld", gServiceHandle, dwStatus); 
		pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, szText);
    }
*/

    if (dwStatus == SERVICE_RUNNING || dwStatus == SERVICE_STOPPED)
    {
        gServiceStatus.dwWaitHint = 0;
    }
	gServiceStatus.dwCurrentState = dwStatus;
	gServiceStatus.dwCheckPoint = dwCheckPoint;
	SetServiceStatus (gServiceHandle, &gServiceStatus);
}
