// TLVBuffer.h: interface for the CTLVBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLVBUFFER_H__E687DC32_54AD_4FE8_A520_2060F03D8729__INCLUDED_)
#define AFX_TLVBUFFER_H__E687DC32_54AD_4FE8_A520_2060F03D8729__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _WIN32
    #pragma warning(disable : 4786 4514 4702 4710)
#endif

#include <map>
#include "TLV.h"
#include "eidlib.h"

namespace eidviewer
{

class CTLVBuffer  
{
public:
	CTLVBuffer();
	virtual ~CTLVBuffer();
    
    bool ParseTLV(unsigned char *pucData, unsigned long ulLen);
    bool MakeTLV(BEID_Raw *pRawData, BEID_Bytes *pOneRaw);

    CTLV *GetTagData(unsigned char ucTag);
    void FillASCIIData(unsigned char ucTag, char *pData);
    void FillUTF8Data(unsigned char ucTag, char *pData);
    void FillBinaryStringData(unsigned char ucTag, char *pData);
    void FillIntData(unsigned char ucTag, int *piData);
    void FillLongData(unsigned char ucTag, long *piData);
    void FillBinaryData(unsigned char ucTag, unsigned char *pData);
    void FillBinaryData(unsigned char ucTag, unsigned char *pData, unsigned long *pulLen);
    unsigned long GetLengthForSignature();
    char *Hexify(unsigned char * pData, unsigned long ulLen);
protected:
    int BytesToInt(unsigned char * pData, unsigned long ulLen);
    bool TlvEncodeLen(unsigned long ulLenVal, unsigned char *pucBufDest, int *piBufLen);
    bool TlvDecodeLen(unsigned char *pucBufSrc, int *piBufLen,  unsigned long *pulLenVal);

private:
    static char hexChars[];
    std::map<unsigned char, CTLV *> m_oMapTLV;
    typedef std::map<unsigned char, CTLV *>::iterator ITMap;

};

} // namespace

#endif // !defined(AFX_TLVBUFFER_H__E687DC32_54AD_4FE8_A520_2060F03D8729__INCLUDED_)
