#include "GuiDlg.h"
#include "wxwalldlg.h"


BEGIN_EVENT_TABLE(CVerifyDlg, wxDialog)
    EVT_BUTTON(ID_BUTTON_OK, CVerifyDlg::OnButtonOK)
    EVT_BUTTON(ID_BUTTON_CANCEL, CVerifyDlg::OnButtonCancel)
END_EVENT_TABLE()

CVerifyDlg::CVerifyDlg(wxWindow *parent) : wxDialog(parent, -1, _("Enter Smart Card PIN"), wxDefaultPosition, 
                                                      wxDefaultSize)
{
    VerifyDialogFunc(this, TRUE);
}

void CVerifyDlg::OnButtonOK(wxCommandEvent& event)
{
    wxTextCtrl *pPINText = (wxTextCtrl *)FindWindow(IDC_EDIT_PIN);

    if(pPINText != NULL)
    {
        m_strPin = pPINText->GetValue();
    }
    if(m_strPin.Length() < MIN_PINSIZE)
    {
        wxStaticText *pErrorText = (wxStaticText *)FindWindow(IDC_STATIC_LABEL_VERIFYERROR);
        if(pErrorText != NULL)
        {
            pErrorText->SetLabel(_("Wrong PIN length (minimum 4 digits)"));
        }
        pPINText->SetSelection(-1, -1);
        pPINText->SetFocus();
        return;
    }
    EndModal(ID_BUTTON_OK);
}

void CVerifyDlg::OnButtonCancel(wxCommandEvent& event)
{
    EndModal(ID_BUTTON_CANCEL);
}

// Implement window functions
wxSizer *VerifyDialogFunc( wxWindow *parent, bool call_fit, bool set_sizer )
{
    wxBoxSizer *item0 = new wxBoxSizer( wxVERTICAL );

    wxBoxSizer *item1 = new wxBoxSizer( wxHORIZONTAL );

    wxStaticBitmap *item2 = new wxStaticBitmap( parent, IDC_STATIC_ICON_VERIFYSMARTCARD, MyBitmapsFunc( 1 ), wxDefaultPosition, wxDefaultSize );
    item1->Add( item2, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxStaticText *item3 = new wxStaticText( parent, IDC_STATIC_LABEL_VERIFYHEADER, _("Please enter the PIN for your smart card."), wxDefaultPosition, wxDefaultSize, 0 );
    item1->Add( item3, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item1, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxBoxSizer *item4 = new wxBoxSizer( wxHORIZONTAL );

    wxStaticText *item5 = new wxStaticText( parent, IDC_STATIC_PIN_LABEL, _("PIN:"), wxDefaultPosition, wxDefaultSize, 0 );
    item4->Add( item5, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxTextCtrl *item6 = new wxTextCtrl( parent, IDC_EDIT_PIN, wxT(""), wxDefaultPosition, wxSize(80,-1), wxTE_PASSWORD );
    item6->SetMaxLength(MAX_PINSIZE);
    item4->Add( item6, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item4, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxStaticText *item7 = new wxStaticText( parent, IDC_STATIC_LABEL_VERIFYERROR, wxT(""), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE );
    item7->SetForegroundColour( *wxRED );
    item0->Add( item7, 0, wxALIGN_CENTRE|wxEXPAND|wxALL, 5 );

    wxBoxSizer *item8 = new wxBoxSizer( wxHORIZONTAL );

    wxButton *item9 = new wxButton( parent, ID_BUTTON_OK, _("OK"), wxDefaultPosition, wxDefaultSize, 0 );
    item9->SetDefault();
    item8->Add( item9, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxButton *item10 = new wxButton( parent, ID_BUTTON_CANCEL, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    item8->Add( item10, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item8, 0, wxALIGN_CENTRE|wxALL, 5 );

    if (set_sizer)
    {
        parent->SetAutoLayout( TRUE );
        parent->SetSizer( item0 );
        if (call_fit)
        {
            item0->Fit( parent );
            item0->SetSizeHints( parent );
        }
    }
    
    return item0;
}


/////////////////////////////////
// Change Dlg
////////////////////////////////

BEGIN_EVENT_TABLE(CChangeDlg, wxDialog)
    EVT_BUTTON(ID_BUTTON_OK, CChangeDlg::OnButtonOK)
    EVT_BUTTON(ID_BUTTON_CANCEL, CChangeDlg::OnButtonCancel)
END_EVENT_TABLE()

CChangeDlg::CChangeDlg(wxWindow *parent) : wxDialog(parent, -1, _("Change Smart Card PIN code"), wxDefaultPosition, 
                                                      wxDefaultSize)
{
    ChangeDialogFunc(this, TRUE);
}

void CChangeDlg::OnButtonOK(wxCommandEvent& event)
{
    wxTextCtrl *pPINOldText = (wxTextCtrl *)FindWindow(IDC_EDIT_OLDPIN);
    wxTextCtrl *pPINNewText = (wxTextCtrl *)FindWindow(IDC_EDIT_NEWPIN);
    wxTextCtrl *pPINConfirmText = (wxTextCtrl *)FindWindow(IDC_EDIT_CONFIRMPIN);
    wxString strOld;
    wxString strNew;
    wxString strConfirm;

    if(pPINOldText != NULL)
    {
        strOld = pPINOldText->GetValue();
    }
    if(pPINNewText != NULL)
    {
        strNew = pPINNewText->GetValue();
    }
    if(pPINConfirmText != NULL)
    {
        strConfirm = pPINConfirmText->GetValue();
    }

    wxTextCtrl *pFocus = NULL;
    if(strOld.Length() < MIN_PINSIZE)
    {
        pFocus = pPINOldText;
    }
    else if(strNew.Length() < MIN_PINSIZE)
    {
        pFocus = pPINNewText;
    }
    else if(strConfirm.Length() < MIN_PINSIZE)
    {
        pFocus = pPINConfirmText;
    }

    wxStaticText *pErrorText = (wxStaticText *)FindWindow(IDC_STATIC_LABEL_CHANGEERROR);
    if(pFocus != NULL)
    {
        if(pErrorText != NULL)
        {
            pErrorText->SetLabel(_("Wrong PIN length (minimum 4 digits)"));
        }
        pFocus->SetSelection(-1, -1);
        pFocus->SetFocus();
        return;
    }

    if(strNew != strConfirm)
    {
        if(pErrorText != NULL)
        {
            pErrorText->SetLabel(_("The new PINs you entered were different."));
        }
        pPINConfirmText->SetSelection(-1, -1);
        pPINConfirmText->SetFocus();
        return;
    }
    m_strPinOld = strOld;
    m_strPinNew = strNew;

    EndModal(ID_BUTTON_OK);
}

void CChangeDlg::OnButtonCancel(wxCommandEvent& event)
{
    EndModal(ID_BUTTON_CANCEL);
}

wxSizer *ChangeDialogFunc( wxWindow *parent, bool call_fit, bool set_sizer )
{
    wxBoxSizer *item0 = new wxBoxSizer( wxVERTICAL );

    wxBoxSizer *item1 = new wxBoxSizer( wxHORIZONTAL );

    wxStaticBitmap *item2 = new wxStaticBitmap( parent, IDC_STATIC_ICON_CHANGESMARTCARD, MyBitmapsFunc( 1 ), wxDefaultPosition, wxDefaultSize );
    item1->Add( item2, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxStaticText *item3 = new wxStaticText( parent, IDC_STATIC_LABEL_CHANGEHEADER, _("You must know your current PIN in order to change it."), wxDefaultPosition, wxDefaultSize, 0 );
    item1->Add( item3, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item1, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxGridSizer *item4 = new wxGridSizer( 2, 0, 0 );

    wxStaticText *item5 = new wxStaticText( parent, IDC_STATIC_OLDPIN_LABEL, _("Old PIN:"), wxDefaultPosition, wxDefaultSize, 0 );
    item4->Add( item5, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxTextCtrl *item6 = new wxTextCtrl( parent, IDC_EDIT_OLDPIN, wxT(""), wxDefaultPosition, wxSize(80,-1), wxTE_PASSWORD );
    item6->SetMaxLength(MAX_PINSIZE);
    item4->Add( item6, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxStaticText *item7 = new wxStaticText( parent, IDC_STATIC_NEWPIN_LABEL, _("New PIN:"), wxDefaultPosition, wxDefaultSize, 0 );
    item4->Add( item7, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxTextCtrl *item8 = new wxTextCtrl( parent, IDC_EDIT_NEWPIN, wxT(""), wxDefaultPosition, wxSize(80,-1), wxTE_PASSWORD );
    item8->SetMaxLength(MAX_PINSIZE);
    item4->Add( item8, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxStaticText *item9 = new wxStaticText( parent, IDC_STATIC_CONFIRMPIN_LABEL, _("Confirm New PIN:"), wxDefaultPosition, wxDefaultSize, 0 );
    item4->Add( item9, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxTextCtrl *item10 = new wxTextCtrl( parent, IDC_EDIT_CONFIRMPIN, wxT(""), wxDefaultPosition, wxSize(80,-1), wxTE_PASSWORD );
    item10->SetMaxLength(MAX_PINSIZE);
    item4->Add( item10, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item4, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxStaticText *item11 = new wxStaticText( parent, IDC_STATIC_LABEL_CHANGEERROR, wxT(""), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE );
    item11->SetForegroundColour( *wxRED );
    item0->Add( item11, 0, wxALIGN_CENTRE|wxEXPAND|wxALL, 5 );

    wxBoxSizer *item12 = new wxBoxSizer( wxHORIZONTAL );

    wxButton *item13 = new wxButton( parent, ID_BUTTON_OK, _("OK"), wxDefaultPosition, wxDefaultSize, 0 );
    item13->SetDefault();
    item12->Add( item13, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxButton *item14 = new wxButton( parent, ID_BUTTON_CANCEL, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    item12->Add( item14, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item12, 0, wxALIGN_CENTRE|wxALL, 5 );

    if (set_sizer)
    {
        parent->SetAutoLayout( TRUE );
        parent->SetSizer( item0 );
        if (call_fit)
        {
            item0->Fit( parent );
            item0->SetSizeHints( parent );
        }
    }
    
    return item0;
}
