/*
 * Copyright © Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Author: David Reveman <davidr@novell.com>
 *
 */

#include <X11/Xlib.h>
#include <string.h>
#include <beryl.h>
#include <beryl-private.h>
#include <fsp.h>

//this code is thanks to the wonderful work and documentation in kwin

#define FSP(x) (x)->screen->display->focusStealingLevel

static int timestampCompare(Time t1, Time t2)
{
	if (t1 == t2)
		return 0;
	return (t1 - t2) < 0x7fffffffU ? 1 : -1;
}

Bool shouldFocusWindow(CompWindow * w, Time t1)
{
	// KWIN Focus Stealing Levels:
	// 0 - none, new windows always get focus
	// 1 - low, allow activation if unsure
	// 2 - normal, disallow if not sure
	// 3 - high, only focus if belongs to active app
	// 4 - extreme, only user-initiated focus

	if (FSP(w) == FSP_NONE)
		return TRUE;
	if (FSP(w) == FSP_EXTREME)
		return FALSE;

	if (w->type & (CompWindowTypeDesktopMask |
		   		   CompWindowTypeDockMask |
				   CompWindowTypeSplashMask))
		return FALSE;

	if (w->state & CompWindowStateOffscreenMask)
		return FALSE;

	if (w->initialViewportX != w->screen->x ||
        w->initialViewportY != w->screen->y)
         return FALSE;

	if (w->desktop != w->screen->currentDesktop)
		return FALSE;

	if (!w->inputHint && !(w->protocols & CompWindowProtocolTakeFocusMask))
		return FALSE;

	if (t1 == -1U)
	{
		if (!getWindowUserTime(w, &t1))
			t1 = -1U;
		if (t1 == -1U && w->initialTimestampSet)
			t1 = w->initialTimestamp;
		if (t1 == -1U)
			if (!getWindowCreationTime(w, &t1))
				t1 = -1U;
	}

	if (!t1)
		return FALSE;

	CompWindow *active = findWindowAtDisplay(w->screen->display,
										  w->screen->display->activeWindow);

	if (!active)
		return TRUE;

	if (active->type & CompWindowTypeDesktopMask)
		return TRUE;

	if (active->clientLeader == w->clientLeader ||
		(active->resClass && w->resClass && !strcmp(active->resClass, w->resClass)))
		return TRUE;

	if (FSP(w) == FSP_HIGH)
		return FALSE;

	if (t1 == -1U)
	{
		if (FSP(w) == FSP_LOW)
			return TRUE;
		else
			return FALSE;
	}
	Time t2;

	if (!getWindowUserTime(active, &t2))
		t2 = -1U;
	return timestampCompare(t1, t2) >= 0;
}
