/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef APPLICATION_H_
#define APPLICATION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef DEBUG
#include "DebugAgent.h"
#endif
#include "InterthreadCommandQueue.h"
#include "NetworkActivityHandler.h"
#include "FilterJsLogHandler.h"
#include "RequestLogHandler.h"
#include <sigc++/sigc++.h>
#include <gtkmm/main.h>
#include <glibmm/dispatcher.h>
#include <string>
#include <memory>

class ObsoleteForwardingInfo;
class FileVersion;

namespace GtkGUI
{

class ConfigFile;
class ForwardingConfigFile;
class UrlsFile;
class ContentFilters;
class TrayMenu;
class TrayIcon;
class DebugWindow;

class Application :
	private InterthreadCommandQueue::Notifier,
	public sigc::trackable
{
private:
	Application(int argc, char* argv[]);
	
	~Application();
	
	void run();
public:
	static void entryPoint(int argc, char* argv[]);
	
	static Application* instance() { return m_spInstance; }
	
	RequestLogHandler& getRequestLogHandler() { return m_requestLogHandler; }
	
	void showTrayMenu(guint button, guint32 activate_time);
	
	void showAboutDialog();
	
	void showLogDialog();
	
	void showBasicConfigDialog();
	
	void showAdvancedConfigWindow();
	
	void showFilterConfigWindow();
	
	void showForwardingConfigWindow();
	
	void showRequestLogWindow();
#ifdef DEBUG
	void showDebugWindow();
	
	DebugWindow* debugWindow() { return m_ptrDebugWindow.get(); }
#endif
	void requestAppExit();
public:
	std::string getConfigFileName() const;
	
	std::string getConfigDefaultFileName() const;
	
	std::string getStandardUrlPatternsFileName() const;
	
	std::string getLocalUrlPatternsFileName() const;
	
	std::string getGlobalFiltersDir() const;
	
	std::string getUserFiltersDir() const;
	
	GtkGUI::ConfigFile& configFile() { return *m_ptrConfigFile; }
	
	GtkGUI::ForwardingConfigFile& forwardingConfigFile() { return *m_ptrFwdConfigFile; }
	
	GtkGUI::UrlsFile& urlsFile() { return *m_ptrUrlsFile; }
	
	GtkGUI::UrlsFile& urlsLocalFile() { return *m_ptrUrlsLocalFile; }
	
	GtkGUI::ContentFilters& contentFilters() { return *m_ptrContentFilters; }
	
	sigc::signal<void>& destroySignal() { return m_destroySignal; }
	
	void handleNetworkActivity();
private:
	class WorkerThreadPoolActivator;
	
	enum { COMMAND_QUEUE_CAPACITY = 32 };
	
	virtual void notifyCommandsPending();
	
	virtual void notifyQueueEmpty();
	
	void processCommands();
	
	bool createMissingUserConfigs();
	
	static bool copyFile(std::string const& source, std::string const& target);
	
	static bool fileExists(std::string const& path);
	
	static bool fileExists(std::string const& dir, std::string const& file);
	
	static Application* m_spInstance;
	bool m_isExiting;
	int m_commandNestLevel;
	sigc::signal<void> m_destroySignal;
	Gtk::Main m_gtkMain; // many other things depend on it
	Glib::Dispatcher m_dispatcher;
	InterthreadCommandQueue m_commandQueue;
	NetworkActivityHandler m_networkActivityHandler;
	FilterJsLogHandler m_filterJsLogHandler;
	RequestLogHandler m_requestLogHandler;
	std::string m_userConfDir;
	std::string m_globalConfDir;
	std::auto_ptr<ConfigFile> m_ptrConfigFile;
	std::auto_ptr<ForwardingConfigFile> m_ptrFwdConfigFile;
	std::auto_ptr<UrlsFile> m_ptrUrlsFile;
	std::auto_ptr<UrlsFile> m_ptrUrlsLocalFile;
	std::auto_ptr<ContentFilters> m_ptrContentFilters;
	std::auto_ptr<TrayIcon> m_ptrTrayIcon;
	std::auto_ptr<TrayMenu> m_ptrTrayMenu;
#ifdef DEBUG
	DebugAgent m_debugAgent;
	std::auto_ptr<DebugWindow> m_ptrDebugWindow;
#endif
};

} // namespace GtkGUI

#endif
