/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AvailableFiltersOrdered.h"
#include "AvailableContentFilters.h"
#include "RegexFilterDescriptor.h"
#include <algorithm>

namespace
{

class OrderComp
{
public:
	typedef IntrusivePtr<RegexFilterDescriptor const> FilterConstPtr;
	
	bool operator()(FilterConstPtr const& lhs,
	                FilterConstPtr const& rhs) const {
		return *lhs < *rhs;
	}
};

}

AvailableFiltersOrdered::AvailableFiltersOrdered()
{
}

AvailableFiltersOrdered::AvailableFiltersOrdered(
	AvailableFiltersOrdered const& other)
:	m_filters(other.m_filters)
{
}

AvailableFiltersOrdered::AvailableFiltersOrdered(
	AvailableContentFilters const& unordered)
:	m_filters(unordered.begin(), unordered.end())
{
	stable_sort(m_filters.begin(), m_filters.end(), OrderComp());
}

AvailableFiltersOrdered::~AvailableFiltersOrdered()
{
}

AvailableFiltersOrdered&
AvailableFiltersOrdered::operator=(AvailableFiltersOrdered const& rhs)
{
	AvailableFiltersOrdered(rhs).swap(*this);
	return *this;
}

void
AvailableFiltersOrdered::swap(AvailableFiltersOrdered& other)
{
	m_filters.swap(other.m_filters);
}
