/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNodeWithAttributes.h"
#include "HtmlEscaper.h"

HtmlNodeWithAttributes::HtmlNodeWithAttributes(BString const& name, bool closed)
:	m_name(name),
	m_type(0),
	m_isClosed(closed),
	m_adMark(false)
{
}

HtmlNodeWithAttributes::HtmlNodeWithAttributes(HtmlNodeWithAttributes const& other)
:	m_name(other.m_name),
	m_attributes(other.m_attributes),
	m_type(other.m_type),
	m_isClosed(other.m_isClosed),
	m_adMark(other.m_adMark)
{
}

BString const&
HtmlNodeWithAttributes::getTagName() const
{
	return m_name;
}

void
HtmlNodeWithAttributes::setTagName(BString const& name)
{
	m_name = name;
}

int
HtmlNodeWithAttributes::getTagType() const
{
	return m_type;
}

void
HtmlNodeWithAttributes::setTagType(int type)
{
	m_type = type;
}

bool
HtmlNodeWithAttributes::isClosed() const
{
	return m_isClosed;
}

void
HtmlNodeWithAttributes::setClosed(bool closed)
{
	m_isClosed = closed;
}

bool
HtmlNodeWithAttributes::hasAdMark() const
{
	return m_adMark;
}

void
HtmlNodeWithAttributes::setAdMark(bool mark)
{
	m_adMark = mark;
}

HtmlNode::AttributeMap const&
HtmlNodeWithAttributes::getRawAttributes() const
{
	return m_attributes;
}

bool
HtmlNodeWithAttributes::hasAttribute(BString const& name) const
{
	return m_attributes.find(name) != m_attributes.end();
}

bool
HtmlNodeWithAttributes::isBooleanAttribute(BString const& name) const
{
	AttributeMap::const_iterator fit = m_attributes.find(name);
	if (fit == m_attributes.end()) {
		return false;
	} else {
		return fit->second.null();
	}
}

BString
HtmlNodeWithAttributes::getRawAttribute(BString const& name) const
{
	AttributeMap::const_iterator fit = m_attributes.find(name);
	if (fit == m_attributes.end()) {
		return BString();
	} else {
		return fit->second;
	}
}

BString
HtmlNodeWithAttributes::getAttribute(BString const& name) const
{
	return HtmlEscaper::unescape(getRawAttribute(name));
}

void
HtmlNodeWithAttributes::setRawAttribute(BString const& name, BString const& value)
{
	m_attributes[name] = value;
}

void
HtmlNodeWithAttributes::setAttribute(BString const& name, BString const& value)
{
	m_attributes[name] = HtmlEscaper::escape(value);
}

void
HtmlNodeWithAttributes::setBooleanAttribute(BString const& name)
{
	m_attributes[name].clear();
}

void
HtmlNodeWithAttributes::removeAttribute(BString const& name)
{
	m_attributes.erase(name);
}
