/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REPLACEMENTIMAGE_H_
#define REPLACEMENTIMAGE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "SplittableBuffer.h"
#include "BString.h"
#include <stddef.h>
#include <vector>
#include <memory>

class Color;
class ImmediateResponse;
class SBOutStream;

class ReplacementImage
{
public:
	ReplacementImage(int width, int height, Color const* border_color);
	
	SplittableBuffer& binaryData() { return m_binaryData; }
	
	SplittableBuffer const& binaryData() const { return m_binaryData; }
	
	static BString getContentType() { return BString("image/gif"); }
	
	static std::auto_ptr<ImmediateResponse> createHttpResponse(
		int width, int height, int status_code);
private:
	typedef uint16_t LZWCode;
	typedef std::vector<LZWCode> LZWCodeStream;
	
	static void writeScreenDescriptor(SBOutStream& out, int width, int height);
	
	static void writeImageDescriptor(SBOutStream& out,
		int xpos, int ypos, int width, int height);
	
	static void writeLocalColorTable(SBOutStream& out, Color const* border_color);
	
	static void writeImageData(SBOutStream& out, uint8_t color_idx, size_t length);
	
	static void writeLZWCodeStream(LZWCodeStream& strm, uint8_t color_idx, size_t length);
	
	static void packLZWCodeStream(SBOutStream& out, LZWCodeStream const& strm);
	
	static bool isCodeInTable(size_t seqlen, size_t tablepos);
	
	static LZWCode getCodeFor(size_t seqlen, uint8_t color_idx);
	
	static char const HEADER[6];
	static char const GRAPHIC_CONTROL_EXTENSION[8];
	static size_t const TABLE_SIZE;
	static size_t const FIRST_AVAILABLE_CODE;
	static LZWCode const CLEAR_CODE;
	static LZWCode const EOI_CODE;
	SplittableBuffer m_binaryData;
};

#endif
