/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef NFASTATE_H_
#define NFASTATE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include <climits>
#include <set>
#include <map>

class NfaState
{
public:
	typedef int NextStateOffset;
	static NextStateOffset const NO_TRANSITION = INT_MIN;
public:
	NfaState();
	
	~NfaState();
	
	std::set<NextStateOffset> const& getEpsilonTransitions() const {
		return m_epsilonTransitions;
	}
	
	NextStateOffset getSymbolTransition(uint8_t symbol) const;
	
	void setSymbolTransition(uint8_t symbol, NextStateOffset target);
	
	void setDefaultSymbolTransition(NextStateOffset target);
	
	void addEpsilonTransition(NextStateOffset target);
	
	void removeEpsilonTransition(NextStateOffset target);
private:
	std::set<NextStateOffset> m_epsilonTransitions;
	std::map<uint8_t, NextStateOffset> m_symbolTransitions;
	NextStateOffset m_defaultSymbolTransition;
};

#endif
