/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILEVERSION_H_
#define FILEVERSION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <limits>
#include <time.h>

/**
 * \brief Represents file modification time.
 */
class FileVersion
{
	// Member-wise copying is OK.
public:
	/**
	 * \brief Constructs an instance with undefined value.
	 *
	 * You should prefer FileVersion::undefined() over FileVersion().
	 */
	FileVersion() : m_mtime(std::numeric_limits<time_t>::max()) {}
	
	/**
	 * \brief Constructs an instance from external representation.
	 */
	explicit FileVersion(time_t mtime) : m_mtime(mtime) {}
	
	/**
	 * \brief Returns an instance with undefined value.
	 *
	 * You should prefer FileVersion::undefined() over FileVersion().
	 */
	static FileVersion undefined() { return FileVersion(); }
	
	/**
	 * \brief Get external representation.
	 */
	time_t getRep() const { return m_mtime; }
private:
	time_t m_mtime;
};


inline bool operator==(FileVersion const& lhs, FileVersion const& rhs)
{
	return lhs.getRep() == rhs.getRep();
}

inline bool operator!=(FileVersion const& lhs, FileVersion const& rhs)
{
	return lhs.getRep() != rhs.getRep();
}

inline bool operator<(FileVersion const& lhs, FileVersion const& rhs)
{
	return lhs.getRep() < rhs.getRep();
}

inline bool operator>(FileVersion const& lhs, FileVersion const& rhs)
{
	return lhs.getRep() > rhs.getRep();
}

inline bool operator<=(FileVersion const& lhs, FileVersion const& rhs)
{
	return lhs.getRep() <= rhs.getRep();
}

inline bool operator>=(FileVersion const& lhs, FileVersion const& rhs)
{
	return lhs.getRep() >= rhs.getRep();
}

#endif
