/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include "directories.h"
#include "gwrappers.h"
#include <config.h>
#include "stylesheetutils.h"
#include "shell.h"


int main (int argc, char *argv[])
// Exports a stylesheet from Bibledit's database to a zip file with individual style files.
{
  // Usage.
  if (argc != 3) {
    cerr << "Usage: " << argv[0] << " <stylesheet> <outfile>." << endl;
    return 1;
  }
  
  // Check stylesheet.
  ustring stylesheet = argv[1];
  if (!stylesheet_exists (stylesheet)) {
    cerr << "Stylesheet " << stylesheet << " not found." << endl;
    return 1;
  }

  // Make and clear a temporal directory to work in.
  ustring tempdir = gw_build_filename (directories_get_temp(), "stylesheet-export");
  remove_directory (tempdir);
  create_directory (tempdir);
  
  // Get all styles, and export them to xml files in that temporal directory.
  vector<Style> styles;
  stylesheet_get_styles (stylesheet, styles);
  for (unsigned int i = 0; i < styles.size(); i++) {
    ustring filename = gw_build_filename (tempdir, styles[i].marker + STYLE_SUFFIX);
    styles[i].export_it (filename);
  }
  
  // Zip all individual styles. 
  ustring zipfile = "zip.zip";
  ustring command;
  command = "cd ";
  command.append (shell_quote_space (tempdir));
  command.append ("; zip");
  command.append (shell_quote_space (zipfile));
  command.append ("*");
  command.append (STYLE_SUFFIX);
  system (command.c_str());  

  // Get output filename.
  ustring filename = argv[2];
  filename.append (".zip");
  
  // Copy zipfile to outputfile.
  command = "cp";
  command.append (shell_quote_space (gw_build_filename (tempdir, zipfile)));
  command.append (shell_quote_space (filename));
  cout << "Saving to " << filename << endl;
  system (command.c_str());
  
  return 0;
}
