/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "exception.h"
#include "mainwindow.h"
#include "directories.h"
#include "utilities.h"
#include "notes_utils.h"
#include "splashscreen.h"
#include "stylesheetutils.h"
#include "gwrappers.h"
#include "directories.h"
#include "dialogshowscript.h"
#include "shell.h"
#include "user.h"


int main (int argc, char *argv[])
{
  // Unhandled exception handler.
  set_terminate (terminator);
  // Handler for unexpected exceptions.
  set_unexpected (my_unexpected);
  // We need thread support.
  g_thread_init (NULL);
  // Initialize GTK
  gtk_init (&argc, &argv);
  // Do not allow to run as root.
  if (runs_as_root ())
    return 1;
  // Check on default data structure
  directories_check_structure ();
  // Run the backend and terminate if there are commandline arguments
  if (argc > 1) {
    ustring command = "bibledit.backend";
    for (int i = 1; i < argc; i++) {
      command.append (shell_quote_space (argv[i]));
    }
    return system (command.c_str());
  }
  // Save logfile from previous session.
  if (g_file_test (logfile_get_filename().c_str(), G_FILE_TEST_IS_REGULAR)) {
    ustring command;
    command = "mv -f";
    command.append (shell_quote_space (logfile_get_filename()));
    command.append (shell_quote_space (logfile_get_filename() + ".old"));
    system (command.c_str());
  }
  // Redirect stdout and stderr to file.
  {
    // When a file is opened it is always allocated the lowest available file 
    // descriptor. Therefore the following commands cause stdout to be 
    // redirected to the logfile.
    close(1);
    creat (logfile_get_filename().c_str(), 0666); 
    // The dup() routine makes a duplicate file descriptor for an already opened 
    // file using the first available file descriptor. Therefore the following 
    // commands cause stderr to be redirected to the file stdout writes to.
    close(2);
    dup(1);
  }    
  // Splash screen.
  SplashScreen * splashscreen;
  {
    ustring message = "Bibledit starts";
    // Entry in the log.
    gw_message (message);
    // Splash screen. The splash screen is created here and passed on to object 
    // MainWindow, where it also gets destroyed.
    splashscreen = new SplashScreen (0);
    splashscreen->information (message);
    splashscreen->percentage (10);
  }
  // Show logfile name.
  gw_message ("Logfile is " + logfile_get_filename ());
  // Wait until vacuum operations from possible previous session are ready.
  while (program_is_running (BIBLEDIT_VACUUM))
    g_usleep (2000000);    
  // Check on notes database
  notes_database_verify_create ();
  notes_categories_check ();
  splashscreen->percentage (20);
  // Check on styles.
  stylesheet_initial_check ();
  // Start the gui.
  MainWindow mainwindow (splashscreen);
  gtk_main ();
  return 0;
}
