/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_CHAPTER_H
#define INCLUDED_CHAPTER_H

#include "libraries.h"
#include "usfm.h"


class Chapter
{
public:
  Chapter (vector <ustring>& inputlines);
  ~Chapter ();
  void get_verse (const ustring& verse, vector < ustring >& lines);
  void set_verse (vector <ustring>& lines);
  vector <ustring> lines;
private:
  ustring previously_presented_verse;
  void get_verse_boundaries (const ustring& verse, unsigned int &begin, unsigned int &end);
  void get_verse_boundaries_extended (const ustring& verse, unsigned int &begin, unsigned int &end);
};


#endif
