/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOG_PARALLEL_BIBLE_H
#define INCLUDED_DIALOG_PARALLEL_BIBLE_H


#include <gtk/gtk.h>
#include "configuration.h"
#include "ustring.h"
#include "bookmetrics.h"


class ParallelBibleDialog
{
public:
  ParallelBibleDialog (Configuration * configuration);
  virtual ~ParallelBibleDialog ();
  virtual int run ();
protected:
  GtkWidget *parallelbibledialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *label12;
  GtkWidget *hseparator1;
  GtkWidget *hbox3;
  GtkWidget *label13;
  GtkWidget *label_main_project;
  GtkWidget *hbox4;
  GtkWidget *label16;
  GtkWidget *label_book;
  GtkWidget *hbox10;
  GtkWidget *label19;
  GtkWidget *label_chapters;
  GtkWidget *button_chapters;
  GtkWidget *alignment3;
  GtkWidget *hbox11;
  GtkWidget *image3;
  GtkWidget *label20;
  GtkWidget *hseparator2;
  GtkWidget *label15;

  // Additional project.
  vector<GtkWidget *> hboxes;
  vector<GtkWidget *> labels;
  vector<GtkWidget *> comboboxes;
  vector<GtkWidget *> buttons;
  
  GtkWidget *hseparator4;
  GtkWidget *hbox7;
  GtkWidget *button_add;
  GtkWidget *alignment2;
  GtkWidget *hbox8;
  GtkWidget *image2;
  GtkWidget *label18;
  GtkWidget *hseparator5;
  GtkWidget *checkbutton_keep_together;
  GtkWidget *checkbutton_include_verse0;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
private:
  Configuration * myconfiguration;
  static void on_okbutton_clicked (GtkButton *button, gpointer user_data);
  virtual void on_okbutton ();
  static void on_button_additional_project_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_additional_project (GtkButton *button);
  static void on_button_add_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_add (const ustring& project);
  virtual void vector_remove_content (vector<GtkWidget *>& container, int offset);
  virtual void rewrite_button_labels ();
  static void on_button_chapters_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_chapters ();
};


#endif
