/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogreplace.h"
#include "utilities.h"
#include "bible.h"
#include "scripture.h"
#include "dialogselectbooks.h"
#include "search_utils.h"
#include "completion.h"


ReplaceDialog::ReplaceDialog (Configuration* configuration, Session * session, Indexer * worddatabase)
{
  myconfiguration = configuration;
  mysession = session;
  myworddatabase = worddatabase;

  replacedialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (replacedialog), "Replace");
  gtk_window_set_position (GTK_WINDOW (replacedialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (replacedialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (replacedialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (replacedialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);

  label7 = gtk_label_new ("Search for");
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table1), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 4, 4);
  gtk_misc_set_alignment (GTK_MISC (label7), 1, 0.5);

  label8 = gtk_label_new ("Replace with");
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table1), label8, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 4, 4);
  gtk_misc_set_alignment (GTK_MISC (label8), 1, 0.5);

  entry2 = gtk_entry_new ();
  // Manually added code.
  gtk_entry_set_text (GTK_ENTRY (entry2), mysession->searchword.c_str ());
  gtk_widget_show (entry2);
  gtk_table_attach (GTK_TABLE (table1), entry2, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 2);
  gtk_entry_set_activates_default (GTK_ENTRY (entry2), TRUE);

  entry3 = gtk_entry_new ();
  // Manually added code.
  gtk_entry_set_text (GTK_ENTRY (entry3), session->replaceword.c_str ());
  gtk_widget_show (entry3);
  gtk_table_attach (GTK_TABLE (table1), entry3, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 2);
  gtk_entry_set_activates_default (GTK_ENTRY (entry3), TRUE);

  checkbutton1 = gtk_check_button_new_with_mnemonic ("Case _sensitive");
  gtk_widget_show (checkbutton1);
  gtk_table_attach (GTK_TABLE (table1), checkbutton1, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton1), mysession->search_case_sensitive);

  selectbutton = gtk_button_new ();
  gtk_widget_show (selectbutton);
  gtk_table_attach (GTK_TABLE (table1), selectbutton, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (selectbutton), alignment1);

  hbox1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox1);

  image1 = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox1), image1, FALSE, FALSE, 0);

  label9 = gtk_label_new_with_mnemonic ("_Books");
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox1), label9, FALSE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (replacedialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  buttonfind = gtk_button_new_from_stock ("gtk-find");
  gtk_widget_show (buttonfind);
  gtk_dialog_add_action_widget (GTK_DIALOG (replacedialog), buttonfind, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (buttonfind, GTK_CAN_DEFAULT);

  buttoncancel = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (buttoncancel);
  gtk_dialog_add_action_widget (GTK_DIALOG (replacedialog), buttoncancel, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (buttoncancel, GTK_CAN_DEFAULT);

  // The next one modified from Glade's code.
  g_signal_connect ((gpointer) selectbutton, "clicked",
                    G_CALLBACK (on_selectbutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) buttonfind, "clicked",
                    G_CALLBACK (replacedialog_on_buttonfind_clicked), gpointer (this));
  g_signal_connect ((gpointer) entry2, "changed", G_CALLBACK (on_word_entry_changed), gpointer(this));

  gtk_widget_grab_focus (entry2);
  gtk_widget_grab_default (buttonfind);

  // Select books feature.
  Scripture scripture (myconfiguration->project);
  for (unsigned int i = 0; i < scripture.books.size (); i++) {
    selectable_books.push_back (scripture.books[i]);
  }

  // Entry completion
  completion_setup (entry2, cpSearch, session);
  completion_setup (entry3, cpReplace, session);
  
  set_gui();
}


ReplaceDialog::~ReplaceDialog ()
{
  gtk_widget_destroy (replacedialog);
}


int ReplaceDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (replacedialog));
}


void ReplaceDialog::replacedialog_on_buttonfind_clicked (GtkButton *button,
                                                         gpointer user_data)
{
  ((ReplaceDialog*)user_data)->on_buttonfind_clicked ();
}


void ReplaceDialog::on_buttonfind_clicked ()
{
  // Get data from the user interface.
  ustring searchword = gtk_entry_get_text (GTK_ENTRY (entry2));
  mysession->searchword = searchword;
  ustring replaceword = gtk_entry_get_text (GTK_ENTRY (entry3));
  mysession->replaceword = replaceword;
  mysession->search_case_sensitive = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton1));
  // Set a flag if the text is still being indexed at present.
  is_indexing = !myworddatabase->is_ready();
  // Search.
  search_string (mysession, myconfiguration->project, true, results);
  sort_references (results);
  // Highlighting words in editor.
  mysession->highlights_clear ();
  mysession->highlights_add (mysession->searchword, mysession->search_case_sensitive, false, false, false);
  mysession->highlights_add (mysession->replaceword, mysession->search_case_sensitive, false, false, false);
  // Entry completion
  completion_finish (entry2, cpSearch, mysession);
  completion_finish (entry3, cpReplace, mysession);
}


void ReplaceDialog::on_selectbutton_clicked (GtkButton *button,
                                             gpointer user_data)
{
  ((ReplaceDialog*)user_data)->on_selectbutton_clicked2 ();
}


void ReplaceDialog::on_selectbutton_clicked2 ()
{
/*
 * The user can select which books to search and replace in.
 */
  SelectBooksDialog dialog (sbSearch, selectable_books, mysession->selected_books, myconfiguration, mysession);
  dialog.run ();
}


void ReplaceDialog::on_word_entry_changed (GtkEditable * editable, gpointer user_data)
{
  ((ReplaceDialog *) user_data)->set_gui ();
}


void ReplaceDialog::set_gui ()
{
  ustring searchword = gtk_entry_get_text (GTK_ENTRY (entry2));
  gtk_widget_set_sensitive (buttonfind, searchword.size () > 0);
}
