/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOGSELECTCHAPTERS_H
#define INCLUDED_DIALOGSELECTCHAPTERS_H


#include <gtk/gtk.h>
#include "configuration.h"
#include "ustring.h"
#include "bookmetrics.h"


class SelectChaptersDialog
{
public:
  SelectChaptersDialog (BookMetrics * bookmetrics, const ustring& currentselection);
  virtual ~SelectChaptersDialog ();
  virtual int run ();
  ustring new_selection;
protected:
  GtkWidget *selectchaptersdialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *buttonall;
  GtkWidget *alignment5;
  GtkWidget *hbox8;
  GtkWidget *image5;
  GtkWidget *label18;
  GtkWidget *label17;
  GtkWidget *label16;
  GtkWidget *comboboxtochapter;
  GtkWidget *comboboxfromchapter;
  GtkWidget *label19;
  GtkWidget *label20;
  GtkWidget *comboboxfromverse;
  GtkWidget *comboboxtoverse;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
private:
  BookMetrics * mybookmetrics;
  ustring myportion;
  bool driving_combos;
  static void on_okbutton_clicked (GtkButton *button, gpointer user_data);
  virtual void on_okbutton ();
  static void on_comboboxfromchapter_changed (GtkComboBox *combobox, gpointer user_data);
  virtual void on_fromchapter ();
  static void on_comboboxfromverse_changed (GtkComboBox *combobox, gpointer user_data);
  virtual void on_fromverse ();
  static void on_comboboxtochapter_changed (GtkComboBox *combobox, gpointer user_data);
  virtual void on_tochapter ();
  static void on_comboboxtoverse_changed (GtkComboBox *combobox, gpointer user_data);
  virtual void on_toverse ();
  static void on_buttonall_clicked (GtkButton *button, gpointer user_data);
  virtual void on_all ();
  virtual void portion_set (const ustring& selection);
  virtual void verses_from_to (bool called_by_from);
};


#endif
