/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>
#include "fop.h"
#include "java.h"
#include "gwrappers.h"
#include "gtkwrappers.h"
#include "unixwrappers.h"
#include "shell.h"


/*
At first passivetex, xmlpdftex, was used, but printing a full project
caused an overflow of the capacity of TeX. For this reason the switch to FOP was 
made. There was no better free xsl-fo processor available than FOP.
As bibledit aims to produce good quality printed output, we will use FOP
until a better renderer becomes available.
*/


ustring fop_command ()
{
  // Return the command to run script fop, if found.
  ustring returnvalue;
  ustring command = "fop";
  if (unix_which (command))
    returnvalue = command;
  return returnvalue;
}


ustring fop_sh_command (Configuration * configuration)
{
  // Return the command to run script fop.sh, if found.
  ustring fop_sh;
  // FOP not used at present. 
  // fop_sh = gw_build_filename (configuration->fop_home, "fop.sh");
  if (!unix_which (fop_sh))
    fop_sh.clear();
  return fop_sh;
}


bool fop_present (GtkWidget * window, Configuration * configuration)
// Returns whether a script to run fop can be found.
// Gives message if not found.
{
  bool present = false;
  // Try the fop script first.  
  if (!fop_command().empty())
    present = true;
  // Else look for the fop.sh script.
  else if (!fop_sh_command(configuration).empty())
    present = true;
  
  if (!present) {
    ustring message;
    message = "FOP was not found.\n";
    message.append ("FOP is a \"Formatting Objects Processor\".\n");
    message.append ("It is required for printing.\n");
    message.append ("Install FOP first.\n");
    message.append ("For more information see menu Preferences->Formatter.");
    gtkw_dialog_info (window, message);
  }
  return present;
}


ustring fop_convert_to_pdf (Configuration * configuration, const ustring& xslfo, const ustring& pdf, const ustring& logfile)
// Converts file "xslfo" to file "pdf", and returns the result.
{
  // Check the Java environment.
  ustring command;
  if (java_home_environment_variable().empty()) {
    command.append ("JAVA_HOME=");
    command.append (configuration->java_binary); // Out of order at present.
    command.append ("; export JAVA_HOME; ");
  }
  // Try script fop first.
  ustring fop;
  fop = fop_command();
  if (!fop.empty()) {
    command.append (fop);
  } else {
    // Next try script fop.sh.
    fop = fop_sh_command(configuration);
    if (!fop.empty()) {
      command.append (fop);
    }
  }
  command.append (shell_quote_space (xslfo));
  command.append (shell_quote_space (pdf));
  command.append (">");
  command.append (shell_quote_space (logfile));
  command.append ("2>&1 &");
  // Run it, and see whether we succeeded in that.
  if (system (command.c_str()) < 0)
    fop.clear();
  return fop;
}
