/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "progress.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>


Progress::Progress (GtkWidget * progressbar, GtkWidget * notebook)
{
  myprogressbar = progressbar;
  mynotebook = notebook;
  gui();
}


Progress::~Progress ()
{
}


void Progress::start ()
{
  // Notebook shows progress bar.
  gtk_notebook_set_current_page (GTK_NOTEBOOK (mynotebook), 1);
  gtk_progress_bar_set_text (GTK_PROGRESS_BAR (myprogressbar), "");
  gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (myprogressbar), 0);
  cancel = false;
  gui();
}


void Progress::finish ()
{
  // Notebook hides progress bar.
  gtk_notebook_set_current_page (GTK_NOTEBOOK (mynotebook), 0);
  gtk_progress_bar_set_text (GTK_PROGRESS_BAR (myprogressbar), "");
  gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (myprogressbar), 0);
  gui();
}


void Progress::gui ()
{
  // Update the GUI.
  while (gtk_events_pending ()) 
    gtk_main_iteration ();
}


void Progress::set_text (const ustring& text)
{
  gtk_progress_bar_set_text (GTK_PROGRESS_BAR (myprogressbar), text.c_str());
  gui();
}


void Progress::set_fraction (double fraction)
{
  gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (myprogressbar), fraction);
  gui();
}


void Progress::set_iterate (double minimum, double maximum, unsigned int max_iteration)
{
  my_minimum = minimum;
  my_maximum = maximum;
  modulus = 0;
  if (max_iteration > 300)
    modulus = max_iteration / 100;
  my_max_iterations = max_iteration;
  iteration_counter = 0;
  gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (myprogressbar), my_minimum);
  gui ();  
}


void Progress::iterate ()
{
  iteration_counter++;
  // It appears that if there are many steps to take, and so we have many 
  // iterations in the process, the whole process is slowed down mostly by the
  // update of the graphical user interface. As this is not desirable,
  // measures have been taken in the Progress object to automatically reduce
  // the number of iterations depending on how many there are going to be
  // in the process. This can result in something going more than ten (!) 
  // times faster.
  if (modulus != 0) {
    if ((iteration_counter % modulus) != 0)
      return;
  }
  double percentage;
  percentage = double (iteration_counter) / double (my_max_iterations);
  percentage *= (my_maximum - my_minimum);
  percentage += my_minimum;
  // If percentage gets too high, reset the bar.
  if (percentage > 1)
    iteration_counter = 0;
  percentage = CLAMP (percentage, 0, 1);
  gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (myprogressbar), percentage);
  gui();
}
