 /*
  ** Copyright (C) 2003-2006 Teus Benschop.
  **  
  ** This program is free software; you can redistribute it and/or modify
  ** it under the terms of the GNU General Public License as published by
  ** the Free Software Foundation; either version 2 of the License, or
  ** (at your option) any later version.
  **  
  ** This program is distributed in the hope that it will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  ** GNU General Public License for more details.
  **  
  ** You should have received a copy of the GNU General Public License
  ** along with this program; if not, write to the Free Software
  ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **  
  */


#include "libraries.h"
#include "utilities.h"
#include "referenceutils.h"
#include "directories.h"
#include "constants.h"
#include "gwrappers.h"


ustring references_default_filename ()
{
  /*
   * Returns the default filename, where the references are stored automatically
   */
  return gw_build_filename (directories_get_references (), "references");
}


ustring references_searchwords_filename ()
// Returns the filename that contains the searchwords.
{
  return gw_build_filename (directories_get_references (), "searchwords");
}


ustring references_hidden_ones_get_filename (const ustring& project)
{
  return gw_build_filename (directories_get_projects (), project, "hidden-references");
}


vector<ustring> references_hidden_ones_load (Configuration * configuration)
// Loads the references that are hidden in this project.
{
  ReadText rt (references_hidden_ones_get_filename (configuration->project), true, false);
  return rt.lines;
}


void references_hidden_ones_save (vector <ustring>& references, Configuration * configuration)
// Saves the references that are hidden in this project.
{
  write_lines (references_hidden_ones_get_filename (configuration->project), references);
}


void references_hidden_ones_filter (vector <ustring>& references, vector <ustring>& comments, Configuration * configuration)
// Takes "references" as input, and removes from them the ons that are supposed
// to be hidden.
{
  // Load the hidden ones in a set for quicker search.
  vector<ustring> hidden_ones;
  hidden_ones = references_hidden_ones_load (configuration);
  set<ustring> hidden_set (hidden_ones.begin(), hidden_ones.end());
  // Put the references in a temporary container, and copy them back to the 
  // original container, one by one, if they are not hidden.
  vector<ustring> temp_references (references.begin(), references.end());
  vector<ustring> temp_comments (comments.begin(), comments.end());
  references.clear();
  comments.clear();
  for (unsigned int i = 0; i < temp_references.size(); i++) {
    if (hidden_set.find (temp_references[i] + " " + temp_comments[i]) == hidden_set.end()) {
      references.push_back (temp_references[i]);
      comments.push_back (temp_comments[i]);
    }
  }
}
