/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "scripture.h"
#include "utilities.h"
#include "projectutils.h"
#include "bible.h"



Scripture::Scripture (const ustring & project)
// This object encapsulates a Scripture.
{
  myproject = project;
  load ();
}


Scripture::~Scripture ()
{
}


void Scripture::load ()
{
  // Read the books in this Scripture.
  books.clear();
  paths.clear();
  for (unsigned int i = 0; i < NUMBER_OF_BIBLEBOOKS; i++) {
    ustring filename = projectutils_scripture_filename (myproject, index_to_biblebook (i));
    if (g_file_test (filename.c_str(), G_FILE_TEST_IS_REGULAR)) {
      books.push_back (index_to_biblebook (i));
      paths.push_back (filename);
    }
  }
}


int Scripture::get_index_of_book (const ustring & book)
{
  // Returns the index of book in the vector.
  for (unsigned int i = 0; i < books.size (); i++) {
    if (book == books[i])
      return i;
  }
  return -1;
}
