/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "session.h"


Session::Session (int dummy)
{
  searchword.clear();
  replaceword.clear();
  search_case_sensitive = false;
  search_globbing = false;
  search_start_word_match = false;
  search_end_word_match = false;
  search_current_book = false;
  search_page = 0;
  searchresultstype = sstLoad;
  searchbibletimetype = sbttOpenModules;
  selected_books.clear();
  checkmarkercounttype     = cmctNoSort;
  checkcharacterscounttype = chctNoSort;
  area_type    = atRaw;
  area_id      = false;
  area_intro   = false;
  area_heading = false;
  area_chapter = false;
  area_study   = false;
  area_notes   = false;
  area_xref    = false;
  area_verse   = false;
}


Session::~Session ()
{
}


void Session::highlights_clear ()
{
  highlight_words.clear();
  highlight_casesensitives.clear();
  highlight_globbings.clear();
  highlight_matchbegins.clear();
  highlight_matchends.clear();
}


void Session::highlights_add (const ustring& word, bool casesensitive, bool globbing, bool matchbegin, bool matchend)
{
  highlight_words.push_back (word);
  highlight_casesensitives.push_back (casesensitive);
  highlight_globbings.push_back (globbing);
  highlight_matchbegins.push_back (matchbegin);
  highlight_matchends.push_back (matchend);
}
