/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cdynamic.c              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sat Oct 19 10:03:44 2002                          */
/*    Last change :  Tue Mar 30 20:07:22 2004 (serrano)                */
/*    Copyright   :  2002-04 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The global dynamic environment (per thread environment)          */
/*=====================================================================*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    The current dynamic environment                                  */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF bgldenv_t bgl_current_dynamic_env;

/*---------------------------------------------------------------------*/
/*    bgldenv_t                                                        */
/*    bgl_get_current_dynamic_env ...                                  */
/*---------------------------------------------------------------------*/
bgldenv_t
bgl_get_current_dynamic_env() {
   return bgl_current_dynamic_env;
}

/*---------------------------------------------------------------------*/
/*    bgldenv_t                                                        */
/*    make_dynamic_env ...                                             */
/*---------------------------------------------------------------------*/
bgldenv_t
make_dynamic_env() {
   bgldenv_t env = (bgldenv_t)GC_MALLOC( sizeof( struct bgl_dynamic_env ) );

   env->current_output_port = BUNSPEC;
   env->current_error_port = BUNSPEC;
   env->current_input_port = BUNSPEC;

   env->exitd_top = BFALSE;
   env->exitd_stamp = BINT( 0 );
   env->befored_top = 0L;

   env->mvalues_number = 1;
   env->mvalues[ 0 ] = BUNSPEC;
   env->mvalues[ 1 ] = BUNSPEC;
   env->mvalues[ 2 ] = BUNSPEC;
   env->mvalues[ 3 ] = BUNSPEC;

   env->error_handler = BNIL;
   
   env->top_of_frame = 0L;
   env->top.symbol = BUNSPEC;
   env->top.link = 0;
      
   return env;
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bgl_init_dynamic_env ...                                         */
/*---------------------------------------------------------------------*/
void
bgl_init_dynamic_env() {
   bgl_current_dynamic_env = make_dynamic_env(); 
}

/*---------------------------------------------------------------------*/
/*    bgldenv_t                                                        */
/*    bgl_dup_dynamic_env ...                                          */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bgldenv_t
bgl_dup_dynamic_env( bgldenv_t o ) {
   bgldenv_t env = make_dynamic_env();

   env->current_output_port = o->current_output_port;
   env->current_error_port = o->current_error_port;
   env->current_input_port = o->current_input_port;

   return env;
}
