/*=====================================================================*/
/*    .../prgm/project/bigloo/api/pthread/src/Java/bglpmutex.java      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sat Mar  5 13:37:30 2005                          */
/*    Last change :  Tue Jun  7 05:42:48 2005 (serrano)                */
/*    Copyright   :  2005 Manuel Serrano                               */
/*    -------------------------------------------------------------    */
/*    Mutex implementation                                             */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    The package                                                      */
/*---------------------------------------------------------------------*/
package bigloo.pthread;
import java.lang.*;
import bigloo.*;

/*---------------------------------------------------------------------*/
/*    bglpmutex                                                        */
/*---------------------------------------------------------------------*/
public class bglpmutex extends bigloo.mutex {
   private static Object mutexes = bigloo.foreign.BNIL;
   
   protected static void setup() {
      bigloo.mutex.amutex = new bglpmutex( bigloo.foreign.BUNSPEC );
   }

   private boolean locked = false;
   protected Object thread = null;
   
   private Object specific;

   public bglpmutex( Object n ) {
      super( n );
   }

   protected mutex create( Object name ) {
      mutex m = new bglpmutex( name );

      mutexes = foreign.MAKE_PAIR( m, mutexes );
      
      return m;
   }

   protected static void mutexes_unlock( Object thread ) {
      Object w = mutexes;

      while( w instanceof pair ) {
	 bglpmutex m = (bglpmutex)(foreign.CAR( (pair)w ));
	 
	 if( m.thread == thread ) {
	    m.release_lock();
	    m.thread = thread;
	 }
	 w = foreign.CDR( (pair)w );
      }
   }
   
   public synchronized boolean acquire_lock() {
      try {
	 while( locked == true ) {
	    wait();
	 }
	 locked = true;
	 thread = bglpthread.current_thread();
	 notify();
	 return true;
      } catch( Exception e ) {
	 foreign.fail( "mutex-lock!", e.getMessage(), this );
	 return false;
      }
   }

   public synchronized boolean acquire_timed_lock( int ms ) {
      try {
	 wait( ms == 0 ? 1 : (long)ms );
	 if( locked == true ) {
	    return false;
	 } else {
	    locked = true;
	    thread = bglpthread.current_thread();
	    notify();
	    return true;
	 }
      } catch( Exception e ) {
	 foreign.fail( "mutex-lock!", e.getMessage(), this );
	 return false;
      }
   }

   public synchronized boolean release_lock() {
      locked = false;
      thread = null;
      notify();
      return true;
   }

   public static Object SPECIFIC( Object m ) {
      if( m instanceof bglpmutex )
	 return ((bglpmutex) m).specific;
      else
	 return bigloo.foreign.BUNSPEC;
   }

   public static void SPECIFIC_SET( Object m, Object s ) {
      ((bglpmutex) m).specific = s;
   }

   public static Object state( Object m ) {
      bglpmutex mu = (bglpmutex)m;
      
      if( mu.locked == true ) {
	 return mu.thread;
      }
      if( mu.thread == null )
	 return bigloo.foreign.string_to_symbol( "not-abandoned" );
      else
	 return bigloo.foreign.string_to_symbol( "abandoned" );
   }
}
