;; -*-bee-*-
;; Automatically generated file (don't edit), Mon Jun 27 21:55:40 CEST 2005
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/autoconf/jsm.scm.in                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 28 08:49:08 2005                          */
;*    Last change :  Tue Jun 21 09:40:03 2005 (serrano)                */
;*    Copyright   :  2005 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    JSM backend                                                      */
;*=====================================================================*/

(module backend_jsm
   (include "Engine/pass.sch")
   (import engine_param
	   engine_pass
	   engine_link
	   engine_compiler
	   tools_error
	   module_module
	   module_alibrary
	   type_type
	   backend_backend
	   backend_bvm
	   backend_jvm_class
	   backend_jsm_class
	   backend_c_main	; BAD make-bigloo-main
	   read_jvm	; BAD module->qualified-type
	   
	   
	   
	   
	   init_setrc
	   read_reader))

(register-backend! 'jsm build-jsm-backend)

(define (build-jsm-backend)
   (instantiate::jsm
      (language 'jsm)
      (heap-suffix "jheap")
      (heap-compatible 'jvm)
      (foreign-clause-support '(java))
      (debug-support '(jsm))))

(define-method (backend-compile me::jsm)
   ;; the jsm prelude (hello message and *DEST* update)
   (pass-prelude "Jsm" start-jsm-emission! (lambda () (list me)))
   (verbose 2 "      [module: " *module* " qualified type name: "
	    (module->qualified-type *module*) "]"#\Newline)
   ;; CARE: BPS, fix the backend qualified name !!
   (jsm-qname-set! me (string->symbol (module->qualified-type *module*)))
   ;; if we are going to link and we have not found a main yet, we
   ;; have to produce a fake one
   (if (and (not *main*) (memq *pass* '(ld distrib)))
       (set! *main* (make-bigloo-main)))
   ;; the jsm driver
   (define (emit classfile dest)
      (let ((dir *jsm-dir-name*))
	 (if (eq? *pass* 'jsmas)
	     (let ((port (if (not (string? dest))
			     (current-output-port)
			     (open-output-file
			      (string-append dir "/" dest)))))
		(jsmasdump classfile port)
		(if (not (eq? port (current-output-port)))
		    (close-output-port port)))
	     (let* ((cname (if (not (string? dest))
			       (string-append dir "/a.class")
			       (string-append dir "/" dest)))
		    (port (open-output-binary-file cname)))
		(if (not (binary-port? port))
		    (error "jsm-dump" "Can't open file for output" cname))
		(list classfile port)
		(close-binary-port port)))))
   (jsm-check-package *module* *jsm-dir-name*)
   (let ((l* (list me))
	 (bname (cond
		   ((eq? *pass* 'ld)
		    (if (pair? *src-files*)
			(addsuffix (prefix (basename (car *src-files*))))
			"a.class"))
		   ((not (string? *dest*))
		    (if (pair? *src-files*)
			(addsuffix (prefix (basename (car *src-files*))))
			#f))
		   (else
		    (addsuffix (prefix (basename *dest*)))))))
      (emit (car l*) bname)
      (for-each (lambda (cf) (emit cf (jasname cf)))
		(cdr l*) )
      (stop-on-pass 'cc (lambda () 'done))
      (stop-on-pass 'jsmas (lambda () 'done))
      (stop-on-pass 'jast (lambda () 'done)) ))

;*---------------------------------------------------------------------*/
;*    jsm-check-package ...                                            */
;*    -------------------------------------------------------------    */
;*    We check that the class file name is compatible with the         */
;*    JSM qualified type name declared for the class.                  */
;*---------------------------------------------------------------------*/
(define (jsm-check-package module path)
   (define (compare-path? base path)
      (let ((lbase (string-length base))
	    (lpath (string-length path)))
	 (if (< lpath lbase)
	     #f
	     (let loop ((rpath (-fx lpath 1))
			(rbase (-fx lbase 1)))
		(if (=fx rbase -1)
		    #t
		    (let ((cbase (string-ref base rbase))
			  (cpath (string-ref path rpath)))
		       (if (or (char=? cbase cpath)
			       (and (char=? cpath #\/)
				    (char=? cbase #\.)))
			   (loop (-fx rpath 1) (-fx rbase 1))
			   #f)))))))
   (let* ((qtype (module->qualified-type module))
	  (base (let ((pre (prefix qtype)))
		   (cond
		      ((string=? pre "")
		       ".")
		      ((string=? pre qtype)
		       ".")
		      (else
		       pre)))))
      (if (not (compare-path? (jsm-filename base) path))
	  (warning "Incompatible package name and class path."
		   "Package name for module " *module* " is `" base
		   "', class path is `" path "'."))))

(define *jsm-dir-name* ".")

(define (jsmasdump classfile port)
   (let ((ow *pp-width*) (oc *pp-case*))
      (set! *pp-width* 10240)
      (set! *pp-case* 'lower)
      (pp classfile port)
      (set! *pp-case* oc)
      (set! *pp-width* ow)))

(define (addsuffix name)
   (string-append name
		  (case *pass*
		     ((jast)
		      ".jast")
		     ((jsmas)
		      ".jas")
		     (else
		      ".class"))))

(define (jasname cf)
   (match-case cf
      (((class ?name) . ?-)
       (addsuffix (symbol->string name)))))

;*---------------------------------------------------------------------*/
;*    jsm-filename ...                                                 */
;*---------------------------------------------------------------------*/
(define (jsm-filename name)
   (if (string? *jvm-directory*)
       (if (string=? name ".")
	   *jvm-directory*
	   (make-file-name *jvm-directory* name))
       name))

;*---------------------------------------------------------------------*/
;*    jsm-dirname ...                                                  */
;*---------------------------------------------------------------------*/
(define (jsm-dirname file)
   (let* ((dfile (dirname file))
	  (dir (jsm-filename dfile)))
      (if (and (not (string=? dfile ""))
	       (not (directory? dfile))
	       (not (file-exists? dfile))
	       (or (not (string? *jvm-directory*))
		   (directory? *jvm-directory*)))
	  ;; we create the necessary directories to put the JSM class file
	  (make-directories dir))
      dir))

;*---------------------------------------------------------------------*/
;*    start-jsm-emission! ...                                          */
;*---------------------------------------------------------------------*/
(define (start-jsm-emission!)
   (cond
      ((string? *dest*)
       (let ((dname (dirname *dest*)))
	  (if (not (string=? dname ""))
	      (set! *jsm-dir-name* (jsm-dirname *dest*)))))
      ((eq? *pass* 'ld)
       (if (pair? *src-files*)
	   (set! *jsm-dir-name* (jsm-dirname (car *src-files*))))))
   (if (not (and (file-exists? *jsm-dir-name*) (directory? *jsm-dir-name*)))
       (error "start-jsm-emission!"
	      "Can't write dest file because directory doesn't exist"
	      *jsm-dir-name*)
       #t))

      
;*---------------------------------------------------------------------*/
;*    Link                                                             */
;*---------------------------------------------------------------------*/
(define-method (backend-link me::jsm result)
   ;; CARE move the code here...
   (list #f))

;*---------------------------------------------------------------------*/
;*    backend-cnst-table-name ::jsm                                    */
;*---------------------------------------------------------------------*/
(define-method (backend-cnst-table-name me::jsm offset)
   "__cnst")

;*---------------------------------------------------------------------*/
;*    make-link-package ...                                            */
;*---------------------------------------------------------------------*/
(define (make-link-package)
   "JSMMAIN")

;*---------------------------------------------------------------------*/
;*    make-link-module ...                                             */
;*---------------------------------------------------------------------*/
(define (make-link-module)
   (string->symbol (make-link-package)))

;*---------------------------------------------------------------------*/
;*    make-tmp-file-name ...                                           */
;*---------------------------------------------------------------------*/
(define (make-tmp-file-name)
   (string-append (make-link-package) ".bgl"))
 
;*---------------------------------------------------------------------*/
;*    backend-link-objects ::jsm ...                                   */
;*---------------------------------------------------------------------*/
(define-method (backend-link-objects me::jsm sources)
   (define (do-link first module)
      (read-jfile)
      (list module))
   (if (null? sources)
       (let ((first (prefix (car *o-files*))))
	  (warning "link" "No source file found" " -- " *o-files*)
	  ;; we load the library init files.
	  (load-library-init)
	  (do-link first #f))
       ;; on construit la clause du module
       (let loop ((sources sources)
		  (cls '())
		  (main-module #f)
		  (main #f)
		  (fmain "")
		  (libraries '()))
	  (if (null? sources)
	      (if main
		  ;; ce n'est pas la peine de generer un main, il y en a
		  ;; deja un
		  (let ((first (prefix (car *o-files*))))
		     ;; if libraries are used by some module we add them
		     ;; to the link
		     (for-each (lambda (lib)
				  (use-library! (make-library-name lib) 'now))
			       libraries)
		     ;; we load the library init files.
		     (load-library-init)
		     (set! *src-files* (list fmain))
		     (do-link first main-module))
		  ;; on genere un main puis on link.
		  (let ((tmp (make-tmp-file-name)))
		     (make-tmp-main tmp main (make-link-module) cls libraries)
		     (set! *src-files* (list tmp))
		     ;; we have to remove extra mco files before compiler
		     ;; otherwise the compiler will warn about that files.
		     (let liip ((ra  *rest-args*)
				(res '()))
			(cond
			   ((null? ra)
			    (set! *rest-args* (reverse! res)))
			   ((member (suffix (car ra)) *mco-suffix*)
			    (liip (cdr ra) res))
			   (else
			    (liip (cdr ra) (cons (car ra) res)))))
		     (unwind-protect
			(compiler)
			;; we load the library init files.
			(load-library-init)
			(let* ((pre        (prefix tmp))
			       (class-file (string-append pre ".class")))
			   (when (file-exists? tmp)
			      (delete-file tmp))))
		     0))
	      (let ((port (open-input-file (caar sources))))
		 (if (not (input-port? port))
		     (error "" "Illegal file" (caar sources))
		     (let ((exp (compiler-read port)))
			(close-input-port port)
			(match-case exp
			   ((module ?name ??- (main ?new-main) . ?-)
			    (add-qualified-type!
			     name
			     (string-replace (jvm-class-sans-directory
					      (prefix (cdar sources)))
					     (file-separator)
					     #\.))
			    (if main
				(error ""
				       (string-append
					"Redeclaration of the main (files "
					fmain
					" and "
					(caar sources) ")")
				       (cons main new-main)))
			    (loop (cdr sources)
				  (cons (list name
					      (string-append
					       "\"" (caar sources) "\""))
					cls)
				  name
				  new-main
				  (caar sources)
				  (append (find-libraries (cddr exp))
					  libraries)))
			   ((module ?name . ?-)
			    (add-qualified-type!
			     name
			     (string-replace (jvm-class-sans-directory
					      (prefix (cdar sources)))
					     (file-separator)
					     #\.))
			    (loop (cdr sources)
				  (cons (list name
					      (string-append
					       "\"" (caar sources) "\""))
					cls)
				  main-module
				  main
				  fmain
				  (append (find-libraries (cddr exp))
					  libraries)))
			   (else
			    ;; ah, ce n'etait pas un fichier bigloo,
			    ;; on saute (en meprisant :-)
			    (loop (cdr sources)
				  cls
				  main-module
				  main
				  fmain
				  libraries))))))))))   
