/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/ccontrol.c              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Apr 17 13:16:31 1995                          */
/*    Last change :  Tue Jun 21 09:10:01 2005 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Closure allocations.                                             */
/*=====================================================================*/
#include <bigloo.h>
#include <stdarg.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    make_fx_procedure ...                                            */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
make_fx_procedure( obj_t (*entry)(), int arity, int size ) {
   obj_t a_tproc;
   int  byte_size;
 
   byte_size = PROCEDURE_SIZE + ((size-1) * OBJ_SIZE);

   a_tproc = GC_MALLOC( byte_size );
	      
   a_tproc->procedure_t.header   = MAKE_HEADER( PROCEDURE_TYPE, byte_size );
   a_tproc->procedure_t.entry    = entry; 
   a_tproc->procedure_t.va_entry = 0L;
   a_tproc->procedure_t.eval     = BUNSPEC;
   a_tproc->procedure_t.arity    = arity;
	
   return BREF( a_tproc );
}

/*---------------------------------------------------------------------*/
/*    make_va_procedure ...                                            */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
make_va_procedure( obj_t (*entry)(), int arity, int size ) {
   obj_t a_tproc;
   int  byte_size;

   byte_size = PROCEDURE_SIZE + ((size-1) * OBJ_SIZE);

   a_tproc = GC_MALLOC( byte_size );

   a_tproc->procedure_t.header   = MAKE_HEADER( PROCEDURE_TYPE, byte_size );
   a_tproc->procedure_t.entry    = (obj_t (*)())va_generic_entry; 
   a_tproc->procedure_t.va_entry = entry;
   a_tproc->procedure_t.eval     = BUNSPEC;
   a_tproc->procedure_t.arity    = arity;
	
   return BREF( a_tproc );
}

/*---------------------------------------------------------------------*/
/*    va_generic_entry ...                                             */
/*    -------------------------------------------------------------    */
/*    Tous les tests d'arite ont ete expanses `inline'. On n'a plus    */
/*    qu'a faire l'appel.                                              */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
va_generic_entry( obj_t proc, ... ) {
   va_list argl;
   int     arity;
   int     require;
   obj_t   arg[ 16 ];
   obj_t   optional;
   obj_t   runner;
   long    i;
      
   va_start( argl, proc );
   
   arity  = PROCEDURE_ARITY( proc );
   require = -arity - 1;

   for( i = 0; i < require; i++ )
      arg[ i ] = va_arg( argl, obj_t );

   if( (runner = va_arg( argl, obj_t )) != BEOA )
   {
      obj_t tail;
      
      optional = tail = MAKE_PAIR( runner, BNIL );
      
      while( (runner = va_arg( argl, obj_t )) != BEOA )
      {
         SET_CDR( tail, MAKE_PAIR( runner, BNIL ) );
         tail = CDR( tail );
      } 
   }
   else
      optional = BNIL;

   va_end( argl );
   
#define CALL( proc ) ((obj_t (*)())PROCEDURE_VA_ENTRY( proc ))      
   switch( arity )
   {
      case -1  : return CALL( proc )(proc, optional);
      case -2  : return CALL( proc )(proc, arg[ 0 ], optional);
      case -3  : return CALL( proc )(proc, arg[ 0 ], arg[ 1 ], optional);
      case -4  : return CALL( proc )(proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                      optional);
      case -5  : return CALL( proc )(proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], optional);
      case -6  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], optional);
      case -7  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     optional);
      case -8  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], optional);
      case -9  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], optional);
      case -10 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     optional);
      case -11 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], optional);
      case -12 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], optional);
      case -13 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     optional);
      case -14 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], optional);
      case -15 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], arg[ 13 ], optional);
      case -16 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], arg[ 13 ], arg[ 14 ],
                                     optional);
      case -17 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], arg[ 13 ], arg[ 14 ],
                                     arg[ 15 ], optional);
      
      default: C_FAILURE( "va_generic_entry",
			  "too many argument expected",
			  BINT( arity ) );
   }
   return BNIL;
}

/*---------------------------------------------------------------------*/
/*    Eval procedures                                                  */
/*    -------------------------------------------------------------    */
/*    This is a very risky hack. The procedure bgl_eval_procedure,     */
/*    bgl_eval_4procedure, and bgl_eval_4vaprocedure are substitute    */
/*    for subtyping creator. The clean implementation is the Java      */
/*    and Dotnet ones. Since C does not support for subtyping, we      */
/*    have hacked. We use the property that the procedure constructed  */
/*    by the evaluator are in a very limited number and that there     */
/*    is exactly *2* procedure of arity 1, *2* procedure of arity 2,   */
/*    and so on. There is one lambda for un-traced (un-named)          */
/*    procedures and one for traced (named) procedure. tThe exception  */
/*    comes from arity -1. Arity -1 represents functions accepting a   */
/*    variable number of arguments but also functions accepting more   */
/*    than 4 parameters. Hence, we have to use various functions when  */
/*    marking these procedures.                                        */
/*---------------------------------------------------------------------*/
static obj_t (*eval_procedure[ 9 ])();
static obj_t (*eval_traced_procedure[ 9 ])();
static obj_t (*eval_4procedure)();
static obj_t (*eval_traced_4procedure)();
static obj_t (*eval_4vaprocedure)();
static obj_t (*eval_traced_4vaprocedure)();

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    bgl_eval_procedurep ...                                          */
/*---------------------------------------------------------------------*/
bool_t
bgl_eval_procedurep( obj_t proc ) {
   int arity = PROCEDURE_ARITY( proc );
   int idx = arity >= 0 ? arity : -arity + 4;
   obj_t (*entry)() = (arity >= 0) ?
      (obj_t (*)())PROCEDURE_ENTRY( proc )
      : (obj_t (*)())PROCEDURE_VA_ENTRY( proc );

   return (eval_procedure[ idx ] == entry)
      || (eval_traced_procedure[ idx ] == entry);
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    bgl_eval_4procedurep ...                                         */
/*---------------------------------------------------------------------*/
bool_t
bgl_eval_4procedurep( obj_t proc ) {
   obj_t (*entry)() = (obj_t (*)())PROCEDURE_VA_ENTRY( proc );

   return (eval_4procedure == entry) || (eval_traced_4procedure == entry);
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    bgl_eval_4vaprocedurep ...                                       */
/*---------------------------------------------------------------------*/
bool_t
bgl_eval_4vaprocedurep( obj_t proc ) {
   obj_t (*entry)() = (obj_t (*)())PROCEDURE_VA_ENTRY( proc );

   return (eval_4vaprocedure == entry) || (eval_traced_4vaprocedure == entry);
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_eval_procedure ...                                           */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_eval_procedure( obj_t proc ) {
   int arity = PROCEDURE_ARITY( proc );
   int idx = (arity >= 0 ? arity : -arity + 4);
   obj_t (*entry)() = (arity >= 0) ?
      (obj_t (*)())PROCEDURE_ENTRY( proc )
      : (obj_t (*)())PROCEDURE_VA_ENTRY( proc );

   eval_procedure[ idx ] = entry;
   return proc;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_eval_4procedure ...                                          */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_eval_4procedure( obj_t proc ) {
   eval_4procedure = (obj_t (*)())PROCEDURE_VA_ENTRY( proc );
   return proc;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_eval_4vaprocedure ...                                        */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_eval_4vaprocedure( obj_t proc ) {
   eval_4vaprocedure = (obj_t (*)())PROCEDURE_VA_ENTRY( proc );
   return proc;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_eval_traced_procedure ...                                    */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_eval_traced_procedure( obj_t proc ) {
   int arity = PROCEDURE_ARITY( proc );
   int idx = (arity >= 0 ? arity : -arity + 4);
   obj_t (*entry)() = (arity >= 0) ?
      (obj_t (*)())PROCEDURE_ENTRY( proc )
      : (obj_t (*)())PROCEDURE_VA_ENTRY( proc );

   eval_traced_procedure[ idx ] = entry;
   return proc;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_eval_traced_4procedure ...                                   */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_eval_traced_4procedure( obj_t proc ) {
   eval_traced_4procedure = (obj_t (*)())PROCEDURE_VA_ENTRY( proc );
   return proc;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_eval_traced_4vaprocedure ...                                 */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_eval_traced_4vaprocedure( obj_t proc ) {
   eval_traced_4vaprocedure = (obj_t (*)())PROCEDURE_VA_ENTRY( proc );
   return proc;
}
