;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/library.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 23 15:31:39 2005                          */
;*    Last change :  Fri Jun 24 15:34:35 2005 (serrano)                */
;*    Copyright   :  2005 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The library-load facility                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __library
   
   (import __error
	   __thread
	   __eval)
   
   (use     __type
	    __bigloo
	    __tvector
	    __bexit
	    __os
	    __foreign
	    __evenv
	    
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_vectors_6_8
	    __r4_control_features_6_9
	    __r4_pairs_and_lists_6_3
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_strings_6_7
	    __r4_ports_6_10_1
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    __r4_input_6_10_2)

   (export  (library-translation-table::pair-nil)
	    (library-translation-table-add! ::symbol ::bstring)
	    (library-file-name ::symbol ::bstring ::symbol)
	    (library-load ::obj . opt)))

;*---------------------------------------------------------------------*/
;*    *transtable-mutex* ...                                           */
;*---------------------------------------------------------------------*/
(define *transtable-mutex* (make-mutex 'library))

;*---------------------------------------------------------------------*/
;*    *library-transtable* ...                                         */
;*---------------------------------------------------------------------*/
(define *library-transtable* '())

;*---------------------------------------------------------------------*/
;*    library-translation-table ...                                    */
;*---------------------------------------------------------------------*/
(define (library-translation-table)
   *library-transtable*)

;*---------------------------------------------------------------------*/
;*    library-translation-table-add! ...                               */
;*---------------------------------------------------------------------*/
(define (library-translation-table-add! name translation)
   (mutex-lock! *transtable-mutex*)
   (set! *library-transtable*
	 (cons (cons name translation) *library-transtable*))
   (mutex-unlock! *transtable-mutex*))

;*---------------------------------------------------------------------*/
;*    library-init-file ...                                            */
;*---------------------------------------------------------------------*/
(define (library-init-file lib)
   (string-append (symbol->string lib) ".init"))

;*---------------------------------------------------------------------*/
;*    trans-file-name ...                                              */
;*---------------------------------------------------------------------*/
(define (trans-file-name base suf)
   (let ((version (bigloo-config 'release-number)))
      (if (string=? (os-class) "win32")
	  (cond-expand
	     (bigloo-c
	      (string-append base suf))
	     (else
	      (string-append base suf "-" version)))
	  (string-append base suf "-" version))))

;*---------------------------------------------------------------------*/
;*    library-file-name ...                                            */
;*---------------------------------------------------------------------*/
(define (library-file-name lib suf be)
   (let ((trans (assq lib (library-translation-table))))
      (if (not trans)
	  (make-shared-lib-name (string-append (symbol->string lib) suf) be)
	  (make-shared-lib-name (trans-file-name (cdr trans) suf) be))))
	 
;*---------------------------------------------------------------------*/
;*    library-load ...                                                 */
;*---------------------------------------------------------------------*/
(define (library-load lib . path)
   (if (string? lib)
       (dynamic-load lib)
       (let* ((path (if (pair? path)
			path
			(let ((venv (getenv "BIGLOOLIB")))
			   (if (not venv)
			       (list "." (bigloo-config 'library-directory))
			       (cons "." (unix-path->list venv))))))
	      (init (find-file/path (library-init-file lib) path))
	      (be (cond-expand
		     (bigloo-c 'bigloo-c)
		     (bigloo-jvm 'bigloo-jvm)
		     (bigloo-.net 'bigloo-.net))))
	  (when init (loadq init))
	  (let ((lib (find-file/path (library-file-name lib "_s" be) path)))
	     (dynamic-load lib)))))

