/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cwriter.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 17 09:44:20 1991                          */
/*    Last change :  Mon Jul 31 09:39:48 2006 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Object (that have to be non recursives) printing.                */
/*=====================================================================*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t c_constant_string_to_string( char *c_string );
extern obj_t llong_to_string( BGL_LONGLONG_T x, long radix );
extern obj_t bgl_write_obj( obj_t, obj_t );
extern obj_t bgl_display_obj( obj_t, obj_t );

/*---------------------------------------------------------------------*/
/*    Les noms des caracateres                                         */
/*---------------------------------------------------------------------*/
static char *char_name[] = {
   "","","","","","","","",
   "",  "tab", "newline", "", "", "return", "", "",
   "", "","","","","","","",
   "", "", "","","", "", "", "",
   "space", "!", "\"","#","$","%","&","'",
   "(", ")", "*", "+", ",", "-", ".", "/",
   "0", "1", "2", "3", "4", "5", "6", "7",
   "8", "9", ":", ";", "<", "=", ">", "?",
   "@", "A", "B", "C", "D", "E", "F", "G",
   "H", "I", "J", "K", "L", "M", "N", "O",
   "P", "Q", "R", "S", "T", "U", "V", "W",
   "X", "Y", "Z", "[", "\\", "]", "^", "_",
   "`", "a", "b", "c", "d", "e", "f", "g",
   "h", "i", "j", "k", "l", "m", "n", "o",
   "p", "q", "r", "s", "t", "u", "v", "w",
   "x", "y", "z", "{", "|", "}", "~", ""
};

/*---------------------------------------------------------------------*/
/*    PUTC ...                                                         */
/*---------------------------------------------------------------------*/
#define PUTC( port, c ) \
  OUTPUT_PORT( port ).sysputc( c, port )

/*---------------------------------------------------------------------*/
/*    PUTS ...                                                         */
/*    -------------------------------------------------------------    */
/*    This only works for litteral string constants.                   */
/*---------------------------------------------------------------------*/
#define PUTS( port, str ) \
  OUTPUT_PORT( port ).syswrite( str, 1, sizeof( str ) - 1, port )
  
/*---------------------------------------------------------------------*/
/*    PRINTF1 ...                                                      */
/*---------------------------------------------------------------------*/
#define PRINTF1( port, bufsize, ostream, fmt, arg0 ) \
  if( PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( ostream, fmt, arg0 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), port ); \
  }

#ifdef __GNUC__
#  define PRINTF1V( port, bufsize, ostream, fmt, arg0 ) \
  if( PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( ostream, fmt, arg0 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), port ); \
  }
#  else
#  define PRINTF1V( port, bufsize, ostream, fmt, arg0 ) \
  if( PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( ostream, fmt, arg0 ); \
  } else { \
    char *__buf = alloca( bufsize ); \
    sprintf( __buf, fmt, arg0 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), port ); \
  }
#endif

/*---------------------------------------------------------------------*/
/*    PRINTF2 ...                                                      */
/*---------------------------------------------------------------------*/
#define PRINTF2( port, bufsize, stream, fmt, arg0, arg1 ) \
  if( PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( stream, fmt, arg0, arg1 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0, arg1 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), port ); \
  }

#ifdef __GNUC__
#  define PRINTF2V( port, bufsize, stream, fmt, arg0, arg1 ) \
  if( PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( stream, fmt, arg0, arg1 ); \
  } else { \
    char __buf[ bufsize ]; \
    sprintf( __buf, fmt, arg0, arg1 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), port ); \
  }
#  else
#  define PRINTF2V( port, bufsize, stream, fmt, arg0, arg1 ) \
  if( PORT( port ).kindof == KINDOF_FILE ) { \
    fprintf( stream, fmt, arg0, arg1 ); \
  } else { \
    char *__buf = (char *)alloca( bufsize ); \
    sprintf( __buf, fmt, arg0, arg1 ); \
    OUTPUT_PORT( port ).syswrite( __buf, 1, strlen( __buf ), port ); \
  }
#endif

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_substring ...                                        */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_display_substring( obj_t o, long start, long end, obj_t port ) {
   unsigned char *str = &STRING_REF( o, start );
   size_t sz = end - start;
   size_t n = OUTPUT_PORT( port ).syswrite( str, 1, sz, port );

   if( n == sz )
      return port;
   else
      C_SYSTEM_FAILURE( BGL_IO_WRITE_ERROR,
			"display-string",
			"Failed to write all characters of the string",
			o );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_string ...                                           */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_display_string( obj_t o, obj_t port ) {
   return bgl_display_substring( o, 0, STRING_LENGTH( o ), port );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_string ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_string( obj_t o, bool_t esc, obj_t port ) {
   char *str = (char *)BSTRING_TO_STRING( o );
   long len  = STRING_LENGTH( o );

   if( esc ) PUTC( port, '#' );
   
   PUTC( port, '"' );
   OUTPUT_PORT( port ).syswrite( str, 1, len, port );
   PUTC( port, '"' );

   return port;
}


/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_fixnum ...                                           */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_display_fixnum( obj_t o, obj_t port ) {
   PRINTF1( port, 32, PORT( port ).stream, "%ld", CINT( o ) );
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_elong ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_elong( long o, obj_t port ) {
   void *ostream = PORT( port ).stream;

   PRINTF1( port, 32, ostream, "%ld", o );
   
   return port;
}
 
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_elong ...                                              */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_elong( long o, obj_t port ) {
   void *ostream = PORT( port ).stream;

   PRINTF1( port, 32, ostream, "#e%ld", o );
   
   return port;
}
 
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_llong ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_llong( BGL_LONGLONG_T o, obj_t port ) {
   bgl_display_string( llong_to_string( o, 10 ), port );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_llong ...                                              */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_llong( BGL_LONGLONG_T o, obj_t port ) {
   PUTS( port, "#l" );
   bgl_display_string( llong_to_string( o, 10 ), port );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_char ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_char( obj_t o, obj_t port ) {
   int c = CCHAR( o );
   void *ostream = PORT( port ).stream;
   
   if( (c > 0) && (c < 128) && char_name[ c ][ 0 ] ) {
      char *name = char_name[ c ];
	 
      PUTC( port, '#' );
      PUTC( port, '\\' );
      OUTPUT_PORT( port ).syswrite( name, 1, strlen( name ), port );
   } else {
      PUTC( port, '#' );
      PUTC( port, 'a' );

      PRINTF1( port, 4, ostream, "%03d", (unsigned char)(c) );
   }
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_ucs2 ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_ucs2( obj_t o, obj_t port ) {
   PRINTF1( port, 7, PORT( port ).stream, "#u%04x", CUCS2( o ) );
   
   return port;
}   

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_ucs2 ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_ucs2( obj_t o, obj_t port ) {
   ucs2_t ch = CUCS2( o );
   
   if( UCS2_ISOLATIN1P( ch ) ) {
      BGL_DISPLAY_CHAR( (obj_t)BCHAR( ch ), port );
      return port;
   } else
      return bgl_write_ucs2( o, port );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_display_ucs2string ...                                       */
/*---------------------------------------------------------------------*/
obj_t
bgl_display_ucs2string( obj_t o, obj_t port ) {
   int len  = UCS2_STRING_LENGTH( o );
   ucs2_t *ucs2 = BUCS2_STRING_TO_UCS2_STRING( o );
   int i;
   
   if( OUTPUT_STRING_PORTP( port ) ) {
      for( i = 0; i < len; i++ ) {
	 ucs2_t ch = ucs2[ i ];
	 
#if( UCS2_DISPLAYABLE )
#else
	 if( UCS2_ISOLATIN1P( ch ) )
	    PUTC( port, (char)ch );
#endif
      }
   } else {
      for( i = 0; i < len; i++ ) {
	 ucs2_t ch = ucs2[ i ];
	 
#if( UCS2_DISPLAYABLE )
#else
	 if( UCS2_ISOLATIN1P( ch ) )
	    PUTC( port, (char)ch );
#endif
      }
   }
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_utf8string ...                                         */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_utf8string( obj_t o, obj_t port ) {
   char *str = (char *)BSTRING_TO_STRING( o );
   int  len = STRING_LENGTH( o );
   
   PUTS( port, "#u\"" );
   OUTPUT_PORT( port ).syswrite( str, 1, len, port );
   PUTC( port, '"' );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_opaque ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_opaque( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PRINTF2( port, 40, ostream, "#<opaque:%ld:%08lx>",
	    TYPE( o ),
	    (unsigned long)o );
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_cnst ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_cnst( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PRINTF1( port, 7, ostream, "#<%04x>", (int)CCNST( o ) );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_procedure ...                                          */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_procedure( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PRINTF2( port, 96, ostream,
	    "#<procedure:%lx.%ld>",
	    VA_PROCEDUREP( o ) ?
	    (unsigned long)PROCEDURE_VA_ENTRY( o ) :
	    (unsigned long)PROCEDURE_ENTRY( o ),
	    (long)PROCEDURE( o ).arity );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_output_port ...                                        */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_output_port( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PRINTF1V( port, 20 + STRING_LENGTH( PORT( o ).name ),
	     ostream,
	     "#<output_port:%s>",
	     BSTRING_TO_STRING( PORT( o ).name ) );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_input_port ...                                         */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_input_port( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   PUTS( port, "#<input_port:" );
   bgl_display_obj( PORT( o ).name, port );
   PRINTF1( port, 10, ostream, ".%ld>", (long)INPUT_PORT( o ).bufsiz );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_binary_port ...                                        */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_binary_port( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PRINTF2V( port, 40 + STRING_LENGTH( PORT( o ).name ),
	     ostream,
	     "#<binary_%s_port:%s>",
	     BINARY_PORT_INP( o ) ? "input" : "output",
	     BSTRING_TO_STRING( BINARY_PORT( o ).name ) );
   
   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_foreign ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_foreign( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PUTS( port, "#<foreign:" );
   bgl_display_obj( FOREIGN_ID( o ), port );
   PRINTF1( port, 16, ostream, ":%lx>", (long)FOREIGN_TO_COBJ( o ) );

   return port;
}
   
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_process ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_process( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PUTS( port, "#<process:" );
   PRINTF1( port, 20, ostream, "%d>", PROCESS_PID( o ) );

   return port;
}
   
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_socket ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_socket( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PRINTF2V( port,
	     40 + (STRINGP( SOCKET( o ).hostname ) ?
		   STRING_LENGTH( SOCKET( o ).hostname ) :
		   sizeof( "localhost" )),
	     ostream,
	     "#<socket:%s.%d>",
	     STRINGP( SOCKET( o ).hostname ) ?
	     BSTRING_TO_STRING( SOCKET( o ).hostname ) :
	     "localhost",
	     SOCKET( o ).portnum );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_mmap ...                                               */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_mmap( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;
   
   PUTS( port, "#<mmap:" );
   bgl_display_obj( BGL_MMAP( o ).name, port );
   PRINTF1( port, 16, ostream, ":%ld>", (long)BGL_MMAP( o ).length );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_custom ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_custom( obj_t o, obj_t port ) {
   CUSTOM_OUTPUT( o )( o, port );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_write_unknown ...                                            */
/*---------------------------------------------------------------------*/
obj_t
bgl_write_unknown( obj_t o, obj_t port ) {
   void *ostream = PORT( port ).stream;

   if( POINTERP( o ) ) {
      PRINTF2( port, 40, ostream, "#<???:%ld:%08lx>",
	       TYPE( o ) , (unsigned long)o );
   } else {
      PRINTF1( port, 40, ostream, "#<???:%08lx>", (unsigned long)o );
   }

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_ill_char_rep ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bgl_ill_char_rep( unsigned char c ) {
   char aux[ 10 ];

   sprintf( aux, "#a%03d", c );

   return c_constant_string_to_string( aux );
}



