;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/date.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb  4 10:35:59 2003                          */
;*    Last change :  Fri Jul 28 11:05:21 2006 (serrano)                */
;*    Copyright   :  2003-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The operations on time and date.                                 */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/date.texi@                                */
;*       @node Date@                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __date

   (import  __error)

   (use     __type
	    __bigloo
	    __tvector
	    __bexit
	    __param
	    
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_vectors_6_8
	    __r4_control_features_6_9
	    __r4_pairs_and_lists_6_3
	    __r4_characters_6_6
	    __r4_equivalence_6_2 
	    __r4_strings_6_7
	    __r4_ports_6_10_1
	    __foreign
	    __evenv
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    __r4_input_6_10_2)
   
   (extern  (macro c-date?::bool (::obj) "BGL_DATEP")
	    (c-date-new::date (::int ::int ::int ::int ::int ::int ::long ::bool ::int) "bgl_make_date")

	    (infix macro c-date-second=?::bool (::elong ::elong) "==")
	    (infix macro c-date-second<?::bool (::elong ::elong) "<")
	    (infix macro c-date-second>?::bool (::elong ::elong) ">")
	    (infix macro c-date-second<=?::bool (::elong ::elong) "<=")
	    (infix macro c-date-second>=?::bool (::elong ::elong) ">=")
	    (infix macro c-date-second-add::elong (::elong ::elong) "+")
	    (infix macro c-date-second-mul::elong (::elong ::elong) "*")
	    (infix macro c-date-second-sub::elong (::elong ::elong) "-")

	    (macro c-date-integer->second::elong (::long) "(long)")
	    (macro c-date-second::int (::date) "BGL_DATE_SECOND")
	    (macro c-date-minute::int (::date) "BGL_DATE_MINUTE")
	    (macro c-date-hour::int (::date) "BGL_DATE_HOUR")
	    (macro c-date-day::int (::date) "BGL_DATE_DAY")
	    (macro c-date-wday::int (::date) "BGL_DATE_WDAY")
	    (macro c-date-yday::int (::date) "BGL_DATE_YDAY")
	    (macro c-date-month::int (::date) "BGL_DATE_MONTH")
	    (macro c-date-year::int (::date) "BGL_DATE_YEAR")
	    (macro c-date-timezone::long (::date) "BGL_DATE_TIMEZONE")
	    (macro c-date-is-dst::int (::date) "BGL_DATE_ISDST")

	    (c-date-day-name::bstring (::int) "bgl_day_name")
	    (c-date-day-aname::bstring (::int) "bgl_day_aname")
	    (c-date-month-name::bstring (::int) "bgl_month_name")
	    (c-date-month-aname::bstring (::int) "bgl_month_aname")
	    
	    (c-date-current-seconds::elong () "bgl_current_seconds")
	    (c-date-from-seconds::date (::elong) "bgl_seconds_to_date")
	    (c-date-to-seconds::elong (::date) "bgl_date_to_seconds")
	    (c-date-seconds-to-string::bstring (::elong) "bgl_seconds_to_string")
	    (c-date-seconds-to-utc-string::bstring (::elong) "bgl_seconds_to_utc_string"))
	    
   (java    (class foreign
	       (method static c-date?::bool (::obj) "DATEP")
	       (method static c-date-new::date (::int ::int ::int ::int ::int ::int ::long ::bool ::int) "bgl_make_date")
	       (method static c-date-from-seconds::date (::elong) "bgl_seconds_to_date")
	       (method static c-date-current-seconds::elong () "bgl_current_seconds")
	       (method static c-date-to-seconds::elong (::date) "bgl_date_to_seconds")
	       (method static c-date-seconds-to-string::bstring (::elong) "bgl_seconds_to_string")
	       (method static c-date-seconds-to-utc-string::bstring (::elong) "bgl_seconds_to_utc_string")
	       
	       (method static c-date-second=?::bool (::elong ::elong) "secondEQ")
	       (method static c-date-second<?::bool (::elong ::elong) "secondLT")
	       (method static c-date-second<=?::bool (::elong ::elong) "secondLE")
	       (method static c-date-second>?::bool (::elong ::elong) "secondGT")
	       (method static c-date-second>=?::bool (::elong ::elong) "secondGE")
	       (method static c-date-second-add::elong (::elong ::elong) "secondADD")
	       (method static c-date-second-mul::elong (::elong ::elong) "secondMUL")
	       (method static c-date-second-sub::elong (::elong ::elong) "secondSUB")

	       (method static c-date-integer->second::elong (::long) "bgl_integer_to_seconds")
	       (method static c-date-second::int (::date) "BGL_DATE_SECOND")
	       (method static c-date-minute::int (::date) "BGL_DATE_MINUTE")
	       (method static c-date-hour::int (::date) "BGL_DATE_HOUR")
	       (method static c-date-day::int (::date) "BGL_DATE_DAY")
	       (method static c-date-wday::int (::date) "BGL_DATE_WDAY")
	       (method static c-date-yday::int (::date) "BGL_DATE_YDAY")
	       (method static c-date-month::int (::date) "BGL_DATE_MONTH")
	       (method static c-date-year::int (::date) "BGL_DATE_YEAR")
	       (method static c-date-timezone::long (::date) "BGL_DATE_TIMEZONE")
	       (method static c-date-is-dst::int (::date) "BGL_DATE_ISDST")
	       
	       (method static c-date-day-name::bstring (::int) "bgl_day_name")
	       (method static c-date-day-aname::bstring (::int) "bgl_day_aname")
	       (method static c-date-month-name::bstring (::int) "bgl_month_name")
	       (method static c-date-month-aname::bstring (::int) "bgl_month_aname")))
	    
   (export  (inline date?::bool ::obj)
	    (make-date #!key
		       (nsec 0) (sec 1) (min 1) (hour 1)
		       (day 1) (month 1) (year 1970)
		       timezone (dst -1))
	    (date-copy date #!key sec min hour day month year)

	    (inline +second::elong ::elong ::elong)
	    (inline *second::elong ::elong ::elong)
	    (inline -second::elong ::elong ::elong)
	    (inline =second::bool ::elong ::elong)
	    (inline <second::bool ::elong ::elong)
	    (inline >second::bool ::elong ::elong)
	    (inline <=second::bool ::elong ::elong)
	    (inline >=second::bool ::elong ::elong)
	    (inline integer->second::elong ::long)
	    
	    (inline date-nanosecond::elong ::date)
	    (inline date-second::int ::date)
	    (inline date-minute::int ::date)
	    (inline date-hour::int ::date)
	    (inline date-day::int ::date)
	    (inline date-wday::int ::date)
	    (inline date-week-day::int ::date)
	    (inline date-yday::int ::date)
	    (inline date-year-day::int ::date)
	    (inline date-month::int ::date)
	    (inline date-year::int ::date)
	    (inline date-timezone::long ::date)
	    (inline date-zone-offset::long ::date)
	    (inline date-is-dst::int ::date)
	    
	    (inline current-seconds::elong)
	    (inline current-date::date)
	    (inline seconds->date::date ::elong)
	    (inline date->seconds::elong ::date)
	    (inline date->string::bstring ::date)
	    (inline date->utc-string::bstring ::date)
	    (inline seconds->string::bstring ::elong)
	    (inline seconds->utc-string::bstring ::elong)
	    
	    (inline day-seconds::elong)
	    (day-name::bstring ::int)
	    (day-aname::bstring ::int)
	    (month-name::bstring ::int)
	    (month-aname::bstring ::int)
	    (date-month-length::int ::date)
	    (inline leap-year?::bool ::int))

   (pragma  (date? (predicate-of date) no-cfa-top nesting)
	    (c-date? (predicate-of date) no-cfa-top nesting)
	    (c-date-second=? args-safe)
	    (c-date-second<? args-safe)
	    (c-date-second>? args-safe)
	    (c-date-second<=? args-safe)
	    (c-date-second>=? args-safe)
	    (c-date-second-add args-safe)
	    (c-date-second-mul args-safe)
	    (c-date-second-sub args-safe)

	    (c-date-integer->second args-safe)
	    (c-date-second args-safe)
	    (c-date-minute args-safe)
	    (c-date-hour args-safe)
	    (c-date-day args-safe)
	    (c-date-wday args-safe)
	    (c-date-yday args-safe)
	    (c-date-month args-safe)
	    (c-date-year args-safe)
	    (c-date-timezone args-safe)))

;*---------------------------------------------------------------------*/
;*    date? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (date? obj)
   (c-date? obj))

;*---------------------------------------------------------------------*/
;*    make-date ...                                                    */
;*    -------------------------------------------------------------    */
;*    Warning: for SRFI-19 compatibility, nanoseconds are an           */
;*    argument, but its value is currently discarded!                  */
;*---------------------------------------------------------------------*/
(define (make-date #!key
                   (nsec 0)
		   (sec 1) (min 1) (hour 1)
		   (day 1) (month 1) (year 1970)
		   timezone (dst -1))
   (if (integer? timezone)
       (c-date-new sec min hour day month year timezone #t dst)
       (c-date-new sec min hour day month year 0 #f dst)))

;*---------------------------------------------------------------------*/
;*    date-copy ...                                                    */
;*---------------------------------------------------------------------*/
(define (date-copy date #!key sec min hour day month year)
   (c-date-new (or sec (date-second date))
	       (or min (date-minute date))
	       (or hour (date-hour date))
	       (or day (date-day date))
	       (or month (date-month date))
	       (or year (date-year date))
	       (date-timezone date)
	       #t
	       (date-is-dst date)))
      
;*---------------------------------------------------------------------*/
;*    =second ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (=second s1 s2)
   (c-date-second=? s1 s2))

;*---------------------------------------------------------------------*/
;*    <second ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (<second s1 s2)
   (c-date-second<? s1 s2))

;*---------------------------------------------------------------------*/
;*    >second ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (>second s1 s2)
   (c-date-second>? s1 s2))

;*---------------------------------------------------------------------*/
;*    <=second ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (<=second s1 s2)
   (c-date-second<=? s1 s2))

;*---------------------------------------------------------------------*/
;*    >=second ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (>=second s1 s2)
   (c-date-second>=? s1 s2))

;*---------------------------------------------------------------------*/
;*    +second ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (+second s1 s2)
   (c-date-second-add s1 s2))

;*---------------------------------------------------------------------*/
;*    *second ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (*second s1 s2)
   (c-date-second-mul s1 s2))

;*---------------------------------------------------------------------*/
;*    -second ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (-second s1 s2)
   (c-date-second-sub s1 s2))

;*---------------------------------------------------------------------*/
;*    integer->second ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (integer->second i)
   (c-date-integer->second i))

;*---------------------------------------------------------------------*/
;*    date-nanosecond ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (date-nanosecond d::date)
   #e0)

;*---------------------------------------------------------------------*/
;*    date-second ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (date-second d::date)
   (c-date-second d))

;*---------------------------------------------------------------------*/
;*    date-minute ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (date-minute d::date)
   (c-date-minute d))

;*---------------------------------------------------------------------*/
;*    date-hour ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (date-hour d::date)
   (c-date-hour d))

;*---------------------------------------------------------------------*/
;*    date-day ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (date-day d::date)
   (c-date-day d))

;*---------------------------------------------------------------------*/
;*    date-week-day ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (date-week-day d::date)
   (c-date-wday d))

;*---------------------------------------------------------------------*/
;*    date-wday ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (date-wday d::date)
   (c-date-wday d))

;*---------------------------------------------------------------------*/
;*    date-year-day ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (date-year-day d::date)
   (c-date-yday d))

;*---------------------------------------------------------------------*/
;*    date-yday ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (date-yday d::date)
   (c-date-yday d))

;*---------------------------------------------------------------------*/
;*    date-month ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (date-month d::date)
   (c-date-month d))

;*---------------------------------------------------------------------*/
;*    date-year ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (date-year d::date)
   (c-date-year d))

;*---------------------------------------------------------------------*/
;*    date-timezone ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (date-timezone d::date)
   (c-date-timezone d))

;*---------------------------------------------------------------------*/
;*    date-zone-offset ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (date-zone-offset d::date)
   (*fx 3600 (c-date-timezone d)))

;*---------------------------------------------------------------------*/
;*    date-is-dst ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (date-is-dst d::date)
   (c-date-is-dst d))

;*---------------------------------------------------------------------*/
;*    current-seconds ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (current-seconds)
   (c-date-current-seconds))

;*---------------------------------------------------------------------*/
;*    current-date ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (current-date)
   (c-date-from-seconds (c-date-current-seconds)))

;*---------------------------------------------------------------------*/
;*    seconds->date ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (seconds->date elong)
   (c-date-from-seconds elong))

;*---------------------------------------------------------------------*/
;*    date->seconds ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (date->seconds date)
   (c-date-to-seconds date))

;*---------------------------------------------------------------------*/
;*    date->string ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (date->string date)
   (seconds->string (date->seconds date)))

;*---------------------------------------------------------------------*/
;*    date->utc-string ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (date->utc-string date)
   (seconds->utc-string (date->seconds date)))

;*---------------------------------------------------------------------*/
;*    seconds->string ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (seconds->string sec)
   (c-date-seconds-to-string sec))

;*---------------------------------------------------------------------*/
;*    seconds->utc-string ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (seconds->utc-string sec)
   (c-date-seconds-to-utc-string sec))

;*---------------------------------------------------------------------*/
;*    day-seconds ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (day-seconds)
   #e86400)

;*---------------------------------------------------------------------*/
;*    day-name ...                                                     */
;*---------------------------------------------------------------------*/
(define (day-name day)
   (cond
      ((<fx day 1)
       (error 'day-name "Illegal day number" day))
      ((>fx day 7)
       (c-date-day-name (+fx 1 (remainder day 7))))
      (else
       (c-date-day-name day))))

;*---------------------------------------------------------------------*/
;*    day-aname ...                                                    */
;*---------------------------------------------------------------------*/
(define (day-aname day)
   (cond
      ((<fx day 1)
       (error 'day-aname "Illegal day number" day))
      ((>fx day 7)
       (c-date-day-aname (+fx 1 (remainder day 7))))
      (else
       (c-date-day-aname day))))

;*---------------------------------------------------------------------*/
;*    month-name ...                                                   */
;*---------------------------------------------------------------------*/
(define (month-name month)
   (cond
      ((<fx month 1)
       (error 'month-aname "Illegal month number" month))
      ((>fx month 12)
       (c-date-month-name (+fx 1 (remainder month 12))))
      (else
       (c-date-month-name month))))

;*---------------------------------------------------------------------*/
;*    month-aname ...                                                  */
;*---------------------------------------------------------------------*/
(define (month-aname month)
   (cond
      ((<fx month 1)
       (error 'month-aname "Illegal month number" month))
      ((>fx month 12)
       (c-date-month-aname (+fx 1 (remainder month 12))))
      (else
       (c-date-month-aname month))))

;*---------------------------------------------------------------------*/
;*    *month-lengths* ...                                              */
;*---------------------------------------------------------------------*/
(define *month-lengths* `#(31 28 31 30 31 30 31 31 30 31 30 31))

;*---------------------------------------------------------------------*/
;*    date-month-length ...                                            */
;*---------------------------------------------------------------------*/
(define (date-month-length d)
   (let ((m (date-month d)))
      (if (=fx m 2)
	  (if (leap-year? (date-year d)) 29 28)
	  (vector-ref *month-lengths* (-fx m 1)))))

;*---------------------------------------------------------------------*/
;*    leap-year? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (leap-year? year)
   (and (=fx (remainder year 4) 0)
	(or (not (=fx (remainder year 100) 0))
	    (=fx (remainder year 400) 0))))

