#!/bin/bash
# Copyright 2009 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
OUT=$1

PORT=$(dbus-send --session --dest=org.desktopcouch.CouchDB --print-reply --type=method_call / org.desktopcouch.CouchDB.getPort 2>/dev/null | grep int32 | awk '{print $2}')

TOKENS=$(python -c "from desktopcouch import local_files; tokens = local_files.get_oauth_tokens(); print ':'.join([tokens['consumer_key'], tokens['consumer_secret'], tokens['token'], tokens['token_secret']])" 2>/dev/null)

if [ -z "$PORT" ]; then
  # D-Bus call failed for some reason, so just punt
  echo ENOCOUCH > $OUT
else
  echo $PORT:$TOKENS > $OUT
fi


