/**
 * Instance of the bookmark service to gain access to the bookmark API.
 *
 * @see http://mxr.mozilla.org/mozilla-central (nsINavBookmarksService.idl)
 */
var bookmarksService = Cc["@mozilla.org/browser/nav-bookmarks-service;1"].
                       getService(Ci.nsINavBookmarksService);

/**
 * Instance of the livemark service to gain access to the livemark API
 *
 * @see http://mxr.mozilla.org/mozilla-central (nsILivemarkService.idl)
 */
var livemarkService = Cc["@mozilla.org/browser/livemark-service;2"].
                      getService(Ci.nsILivemarkService);

/**
 * Instance of the annotation service to gain access to the annotation API
 *
 * @see http://mxr.mozilla.org/mozilla-central (nsIAnnotationService.idl)
 */
var annotationService = Cc["@mozilla.org/browser/annotation-service;1"]
    .getService(Ci.nsIAnnotationService);


/**
 * Create a new URI
 *
 * @param {string} spec
 *        The URI string in UTF-8 encoding.
 * @param {string} originCharset
 *        The charset of the document from which this URI string originated.
 * @param {string} baseURI
 *        If null, spec must specify an absolute URI. Otherwise, spec may be
 *        resolved relative to baseURI, depending on the protocol.
 * @return A URI object
 * @type nsIURI
 */
function createURI(spec, originCharset, baseURI)
{
  let iosvc = Cc["@mozilla.org/network/io-service;1"].
              getService(Ci.nsIIOService);

  return iosvc.newURI(spec, originCharset, baseURI);
}

const GUID_ANNOTATION = "bindwood/uuid";
const PARENT_ANNOTATION = "bindwood/parent";

function clearBookmarks() {
    bookmarksService.removeFolderChildren(bookmarksService.toolbarFolder);
    bookmarksService.removeFolderChildren(bookmarksService.bookmarksMenuFolder);
    bookmarksService.removeFolderChildren(bookmarksService.unfiledBookmarksFolder);

    var items = annotationService.getItemsWithAnnotation(GUID_ANNOTATION, {});
    for each (var item_id in items) {
        annotationService.removeItemAnnotation(item_id, GUID_ANNOTATION);
    }
    var items = annotationService.getItemsWithAnnotation(PARENT_ANNOTATION, {});
    for each (var item_id in items) {
        annotationService.removeItemAnnotation(item_id, PARENT_ANNOTATION);
    }
}

function setGuid(item_id, guid) {
    annotationService.setItemAnnotation(
        item_id, GUID_ANNOTATION, guid,
        0, annotationService.EXPIRE_NEVER);
}

exports.bookmarksService = bookmarksService;
exports.livemarkService = livemarkService;
exports.annotationService = annotationService;
exports.createURI = createURI;
exports.clearBookmarks = clearBookmarks;
exports.setGuid = setGuid;
